/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util.explorer;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.util.explorer.FileList;
import fr.theshark34.openlauncherlib.util.explorer.FilesUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

@ModifiedByFlow
public class ExploredDirectory {
    protected Path directory;

    ExploredDirectory(Path directory) {
        this.directory = directory;
    }

    public FileList allRecursive() {
        return new FileList(FilesUtil.listRecursive(this.directory));
    }

    public FileList list() {
        return new FileList(FilesUtil.list(this.directory));
    }

    public ExploredDirectory sub(String directory) {
        return new ExploredDirectory(FilesUtil.dir(this.directory, directory));
    }

    public Path get(String file) {
        return FilesUtil.get(this.directory, file);
    }

    public FileList subs() {
        List<Path> files = FilesUtil.list(this.directory);
        ArrayList<Path> dirs = new ArrayList<Path>();
        for (Path f : files) {
            if (!Files.isDirectory(f, new LinkOption[0])) continue;
            dirs.add(f);
        }
        return new FileList(dirs);
    }

    public FileList files() {
        List<Path> files = FilesUtil.list(this.directory);
        ArrayList<Path> fs = new ArrayList<Path>();
        for (Path f : files) {
            if (Files.isDirectory(f, new LinkOption[0])) continue;
            fs.add(f);
        }
        return new FileList(fs);
    }

    public Path get() {
        return this.directory;
    }
}

