/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.FailException;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

@ModifiedByFlow
public class Saver {
    private final Path file;
    private final Properties properties;

    @Deprecated
    @ModifiedByFlow
    public Saver(File file) {
        this(file.toPath());
    }

    @ModifiedByFlow
    public Saver(Path file) {
        this.file = file;
        this.properties = new Properties();
        if (Files.exists(this.file, new LinkOption[0])) {
            this.load();
        } else {
            try {
                Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
                Files.createFile(this.file, new FileAttribute[0]);
            }
            catch (Throwable e) {
                throw new FailException("Can't create properties file.");
            }
        }
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
        this.save();
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String get(String key, String def) {
        String value = this.properties.getProperty(key);
        return value == null ? def : value;
    }

    @ModifiedByFlow
    public void save() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);
            this.properties.store(writer, "Generated by the OpenLauncherLib Saver");
            writer.close();
        }
        catch (Throwable t) {
            throw new FailException("Can't save the properties", t);
        }
    }

    @ModifiedByFlow
    public void load() {
        try {
            this.properties.load(Files.newInputStream(this.file, new OpenOption[0]));
        }
        catch (Throwable t) {
            throw new FailException("Can't load the properties", t);
        }
    }

    @ModifiedByFlow
    public void remove(String key) {
        this.properties.remove(key);
        this.save();
    }
}

