/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.util.LogUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ProcessLogManager
extends Thread {
    private boolean print = true;
    private final BufferedReader reader;
    private final InputStreamReader inputStreamReader;
    private Path toWrite;
    private BufferedWriter writer;

    public ProcessLogManager(InputStream input) {
        this(input, (Path)null);
    }

    @Deprecated
    public ProcessLogManager(InputStream input, File toWrite) {
        this(input, toWrite.toPath());
    }

    public ProcessLogManager(InputStream input, Path toWrite) {
        this.inputStreamReader = new InputStreamReader(input, StandardCharsets.UTF_8);
        this.reader = new BufferedReader(this.inputStreamReader);
        this.toWrite = toWrite;
        if (this.toWrite == null) {
            return;
        }
        try {
            this.writer = Files.newBufferedWriter(this.toWrite, new OpenOption[0]);
        }
        catch (IOException e) {
            LogUtil.err("log-err", e.toString());
        }
    }

    @Override
    @ModifiedByFlow
    public void run() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (this.print) {
                    System.out.printf("%s\n", line);
                }
                if (this.writer == null) continue;
                try {
                    this.writer.write(line + "\n");
                }
                catch (IOException e) {
                    LogUtil.err("log-err", e.toString());
                }
            }
        }
        catch (IOException e) {
            LogUtil.err("log-end", e.toString());
            this.interrupt();
        }
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.close();
            this.inputStreamReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public Path getToWrite() {
        return this.toWrite;
    }

    public void setToWrite(Path toWrite) {
        this.toWrite = toWrite;
    }
}

