/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.language.core;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import fr.theshark34.openlauncherlib.configuration.api.Configuration;
import fr.theshark34.openlauncherlib.configuration.core.SimpleConfiguration;
import fr.theshark34.openlauncherlib.language.api.Language;
import fr.theshark34.openlauncherlib.language.api.LanguageInfo;
import fr.theshark34.openlauncherlib.language.api.LanguageManager;
import org.json.JSONObject;

public class SimpleLanguage
implements Language {
    private final Configuration configuration;
    private final LanguageManager manager;
    private final LanguageInfo name;

    public SimpleLanguage(LanguageInfo name, LanguageManager manager, LanguageInfo identify, Configuration configuration) {
        this.name = name;
        this.manager = manager;
        this.configuration = new SimpleConfiguration(manager.getLogger(), new JSONObject().put(identify.get(), (Object)configuration.get(new JSONObject(), new String[0])));
    }

    public void registerLanguage(LanguageInfo identify, Configuration configuration) {
        this.configuration.set((Object)configuration.get(new JSONObject(), new String[0]), identify.get());
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    @ModifiedByFlow
    public String get(LanguageInfo identify, String ... nodes) {
        if (nodes.length == 0) {
            return identify.get();
        }
        String[] buildNodes = new String[nodes.length + 1];
        buildNodes[0] = identify.get();
        System.arraycopy(nodes, 0, buildNodes, 1, nodes.length);
        StringBuilder builder = new StringBuilder();
        for (String node : nodes) {
            builder.append(node);
        }
        if (this.configuration.has(buildNodes) || this.manager.isDefaultLanguage(this.name)) {
            return this.configuration.get(builder.toString(), buildNodes);
        }
        Language language = this.manager.getDefaultLanguage();
        return language != null ? language.get(identify, nodes) : builder.toString();
    }
}

