/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.openlauncherlib;

import fr.flowarg.openlauncherlib.ModifiedByFlow;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

@ModifiedByFlow
public class NewForgeVersionDiscriminator {
    private final String forgeVersion;
    private final String mcVersion;
    private final String forgeGroup;
    private final String mcpVersion;

    public NewForgeVersionDiscriminator(Path directory, String mcVersion, String forgeVersion) throws Exception {
        this(directory.resolve(mcVersion + "-forge-" + forgeVersion + ".json"));
    }

    public NewForgeVersionDiscriminator(Path forgeVersionJson) throws Exception {
        List<String> lines = Files.readAllLines(forgeVersionJson, StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        lines.forEach(sb::append);
        JSONArray array = new JSONObject(sb.toString()).getJSONObject("arguments").getJSONArray("game");
        this.forgeVersion = array.getString(3);
        this.mcVersion = array.getString(5);
        this.forgeGroup = array.getString(7);
        this.mcpVersion = array.getString(9);
    }

    public NewForgeVersionDiscriminator(String forgeVersion, String mcVersion, String mcpVersion) {
        this(forgeVersion, mcVersion, "net.minecraftforge", mcpVersion);
    }

    public NewForgeVersionDiscriminator(String forgeVersion, String mcVersion, String forgeGroup, String mcpVersion) {
        this.forgeVersion = forgeVersion;
        this.mcVersion = mcVersion;
        this.forgeGroup = forgeGroup;
        this.mcpVersion = mcpVersion;
    }

    public String getForgeVersion() {
        return this.forgeVersion;
    }

    public String getMcVersion() {
        return this.mcVersion;
    }

    public String getForgeGroup() {
        return this.forgeGroup;
    }

    public String getMcpVersion() {
        return this.mcpVersion;
    }
}

