/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions.forge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowstringer.StringUtils;
import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.download.json.ModrinthModPackInfo;
import fr.flowarg.flowupdater.download.json.ModrinthVersionInfo;
import fr.flowarg.flowupdater.download.json.OptiFineInfo;
import fr.flowarg.flowupdater.integrations.optifineintegration.IOptiFineCompatible;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowupdater.utils.ModFileDeleter;
import fr.flowarg.flowupdater.utils.Version;
import fr.flowarg.flowupdater.versions.AbstractModLoaderVersion;
import fr.flowarg.flowupdater.versions.ModLoaderUtils;
import fr.flowarg.flowupdater.versions.ParsedLibrary;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ForgeVersion
extends AbstractModLoaderVersion
implements IOptiFineCompatible {
    private final OptiFineInfo optiFineInfo;
    private final String versionId;
    private final boolean shouldUseInstaller;
    private final boolean newInstallerJsonSpec;

    public ForgeVersion(String modLoaderVersion, List<Mod> mods, List<CurseFileInfo> curseMods, List<ModrinthVersionInfo> modrinthMods, ModFileDeleter fileDeleter, CurseModPackInfo curseModPackInfo, ModrinthModPackInfo modrinthModPackInfo, OptiFineInfo optiFineInfo) {
        super(modLoaderVersion, mods, curseMods, modrinthMods, fileDeleter, curseModPackInfo, modrinthModPackInfo, optiFineInfo);
        this.optiFineInfo = optiFineInfo;
        String[] data = this.modLoaderVersion.split("-");
        String vanilla = data[0];
        String forge = data[1];
        Version vanillaVersion = Version.gen(vanilla);
        if (vanillaVersion.isEqualTo(Version.gen("1.20.3"))) {
            throw new IllegalArgumentException("Forge 1.20.3 is not supported. (can't even launch through official launcher!).");
        }
        Version forgeVersion = Version.gen(forge);
        if (data.length == 2) {
            if (forgeVersion.isNewerOrEqualTo(Version.gen("14.23.5.2851"))) {
                this.versionId = vanilla + "-forge-" + forge;
                this.shouldUseInstaller = vanillaVersion.isNewerThan(Version.gen("1.12.2"));
                this.newInstallerJsonSpec = true;
            } else {
                this.versionId = vanilla + "-forge" + this.modLoaderVersion;
                this.shouldUseInstaller = false;
                this.newInstallerJsonSpec = false;
            }
        } else {
            this.versionId = vanillaVersion.isOlderOrEqualTo(Version.gen("1.7.10")) ? vanilla + "-Forge" + forge + "-" + data[2] : vanilla + "-forge" + this.modLoaderVersion;
            this.shouldUseInstaller = false;
            this.newInstallerJsonSpec = false;
        }
    }

    @Override
    public boolean isModLoaderAlreadyInstalled(@NotNull Path installDir) {
        block15: {
            Path versionJsonFile = installDir.resolve(this.versionId + ".json");
            if (Files.notExists(versionJsonFile, new LinkOption[0])) {
                return false;
            }
            try {
                JsonObject object = JsonParser.parseReader((Reader)Files.newBufferedReader(versionJsonFile)).getAsJsonObject();
                if (this.newInstallerJsonSpec) {
                    Path shimJar;
                    String mcpVersion;
                    String vanillaVersionStr = this.vanilla.getName();
                    Version vanillaVersion = Version.gen(vanillaVersionStr);
                    boolean firstPass = ModLoaderUtils.parseNewVersionInfo(installDir, object).stream().allMatch(ParsedLibrary::isInstalled);
                    if (vanillaVersion.isEqualTo(Version.gen("1.12.2"))) {
                        return firstPass;
                    }
                    if (!firstPass) {
                        return false;
                    }
                    Path librariesDir = installDir.resolve("libraries");
                    if (vanillaVersion.isBetweenOrEqual(Version.gen("1.13.2"), Version.gen("1.15.2"))) {
                        Path srgJar;
                        Path slimJarCache;
                        Path slimJar;
                        Path extraJarCache;
                        mcpVersion = this.getMcpVersion(object);
                        Path minecraftDir = librariesDir.resolve("net").resolve("minecraft").resolve("client");
                        Path vanillaDir = minecraftDir.resolve(vanillaVersionStr);
                        Path vanillaMcpDir = minecraftDir.resolve(vanillaVersionStr + "-" + mcpVersion);
                        Path extraJar = vanillaDir.resolve("client-" + vanillaVersionStr + "-extra.jar");
                        if (this.isSlimOrExtraSha1Wrong(extraJar, extraJarCache = vanillaDir.resolve("client-" + vanillaVersionStr + "-extra.jar.cache"), slimJar = vanillaDir.resolve("client-" + vanillaVersionStr + "-slim.jar"), slimJarCache = vanillaDir.resolve("client-" + vanillaVersionStr + "-slim.jar.cache"), srgJar = vanillaMcpDir.resolve("client-" + vanillaVersionStr + "-" + mcpVersion + "-srg.jar"))) {
                            return false;
                        }
                    } else if (vanillaVersion.isBetweenOrEqual(Version.gen("1.16.1"), Version.gen("1.20.2"))) {
                        Path srgJar;
                        Path slimJarCache;
                        Path slimJar;
                        Path extraJarCache;
                        mcpVersion = this.getMcpVersion(object);
                        String clientId = "client-" + vanillaVersionStr + "-" + mcpVersion;
                        Path vanillaMcpDir = librariesDir.resolve("net").resolve("minecraft").resolve("client").resolve(vanillaVersionStr + "-" + mcpVersion);
                        Path extraJar = vanillaMcpDir.resolve(clientId + "-extra.jar");
                        if (this.isSlimOrExtraSha1Wrong(extraJar, extraJarCache = vanillaMcpDir.resolve(clientId + "-extra.jar.cache"), slimJar = vanillaMcpDir.resolve(clientId + "-slim.jar"), slimJarCache = vanillaMcpDir.resolve(clientId + "-slim.jar.cache"), srgJar = vanillaMcpDir.resolve(clientId + "-srg.jar"))) {
                            return false;
                        }
                    }
                    if (vanillaVersion.isBetweenOrEqual(Version.gen("1.13.2"), Version.gen("1.20.2"))) {
                        Path forgeDir = librariesDir.resolve("net").resolve("minecraftforge").resolve("forge").resolve(this.modLoaderVersion);
                        Path universalJar = forgeDir.resolve("forge-" + this.modLoaderVersion + "-universal.jar");
                        Path clientJar = forgeDir.resolve("forge-" + this.modLoaderVersion + "-client.jar");
                        if (Files.notExists(universalJar, new LinkOption[0]) || Files.notExists(clientJar, new LinkOption[0])) {
                            return false;
                        }
                    } else if (vanillaVersion.isNewerOrEqualTo(Version.gen("1.20.4")) && Files.notExists(shimJar = librariesDir.resolve("net").resolve("minecraftforge").resolve("forge").resolve(this.modLoaderVersion).resolve("forge-" + this.modLoaderVersion + "-shim.jar"), new LinkOption[0])) {
                        return false;
                    }
                    break block15;
                }
                return this.parseOldVersionInfo(installDir, object).stream().allMatch(ParsedLibrary::isInstalled);
            }
            catch (Exception e) {
                this.logger.err("An error occurred while checking if the mod loader is already installed.");
                return false;
            }
        }
        return true;
    }

    private String getMcpVersion(@NotNull JsonObject object) {
        List gameArguments = object.getAsJsonObject("arguments").getAsJsonArray("game").asList().stream().filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).collect(Collectors.toList());
        return (String)gameArguments.get(gameArguments.indexOf("--fml.mcpVersion") + 1);
    }

    private boolean isSlimOrExtraSha1Wrong(Path extraJar, Path extraJarCache, Path slimJar, Path slimJarCache, Path srgJar) throws Exception {
        if (Files.notExists(extraJar, new LinkOption[0]) || Files.notExists(extraJarCache, new LinkOption[0]) || Files.notExists(slimJar, new LinkOption[0]) || Files.notExists(slimJarCache, new LinkOption[0]) || Files.notExists(srgJar, new LinkOption[0])) {
            return true;
        }
        String extraJarSha1 = FileUtils.getSHA1((Path)extraJar);
        String slimJarSha1 = FileUtils.getSHA1((Path)slimJar);
        String slimJarCacheSha1 = "";
        for (String line : Files.readAllLines(slimJarCache)) {
            if (!line.contains("Output: ")) continue;
            slimJarCacheSha1 = StringUtils.empty((String)line, (String)"Output: ");
            break;
        }
        String extraJarCacheSha1 = "";
        for (String line : Files.readAllLines(extraJarCache)) {
            if (!line.contains("Output: ")) continue;
            extraJarCacheSha1 = StringUtils.empty((String)line, (String)"Output: ");
            break;
        }
        return !extraJarSha1.equalsIgnoreCase(extraJarCacheSha1) || !slimJarSha1.equalsIgnoreCase(slimJarCacheSha1);
    }

    @NotNull
    private Callable<String> getSha1FromLibrary(@NotNull JsonObject library, String builtJarUrl) {
        JsonElement checksums;
        JsonElement checksumsElem = library.get("checksums");
        if (checksumsElem != null && (checksums = checksumsElem.getAsJsonArray().get(0)) != null) {
            return () -> ((JsonElement)checksums).getAsString();
        }
        return () -> IOUtils.getContent(new URL(builtJarUrl + ".sha1"));
    }

    @Override
    public void install(@NotNull Path installDir) throws Exception {
        super.install(installDir);
        String installerUrl = String.format("https://maven.minecraftforge.net/net/minecraftforge/forge/%s/forge-%s-installer.jar", this.modLoaderVersion, this.modLoaderVersion);
        String[] installerUrlParts = installerUrl.split("/");
        Path installerFile = installDir.resolve(installerUrlParts[installerUrlParts.length - 1]);
        IOUtils.download(this.logger, new URL(installerUrl), installerFile);
        if (this.newInstallerJsonSpec) {
            if (this.shouldUseInstaller) {
                this.useInstaller(installDir, installerFile);
            } else {
                this.logger.info("Installing libraries...");
                URI uri = URI.create("jar:" + installerFile.toAbsolutePath().toUri());
                try (FileSystem zipFs = FileSystems.newFileSystem(uri, new HashMap());){
                    Path versionFile = zipFs.getPath("version.json", new String[0]);
                    Path versionJsonFile = installDir.resolve(this.versionId + ".json");
                    Files.copy(versionFile, versionJsonFile, StandardCopyOption.REPLACE_EXISTING);
                    ModLoaderUtils.parseNewVersionInfo(installDir, JsonParser.parseReader((Reader)Files.newBufferedReader(versionFile)).getAsJsonObject()).stream().filter(parsedLibrary -> !parsedLibrary.isInstalled()).forEach(parsedLibrary -> {
                        if (parsedLibrary.getUrl().isPresent()) {
                            parsedLibrary.download(this.logger);
                        } else {
                            try {
                                String[] name = parsedLibrary.getArtifact().split(":");
                                String group = name[0].replace('.', '/');
                                String artifact = name[1];
                                boolean hasExtension = name[2].contains("@");
                                String version = name[2].contains("@") ? name[2].split("@")[0] : name[2];
                                String extension = hasExtension ? name[2].split("@")[1] : "jar";
                                String classifier = "";
                                if (name.length == 4) {
                                    classifier = "-" + name[3];
                                }
                                Files.createDirectories(parsedLibrary.getPath().getParent(), new FileAttribute[0]);
                                Files.copy(zipFs.getPath("maven/" + group + '/' + artifact + '/' + version + '/' + artifact + "-" + version + classifier + "." + extension, new String[0]), parsedLibrary.getPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (Exception e) {
                                this.logger.printStackTrace((Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    this.logger.printStackTrace((Throwable)e);
                }
            }
        } else {
            this.logger.info("Installing libraries...");
            URI uri = URI.create("jar:" + installerFile.toAbsolutePath().toUri());
            try (FileSystem zipFs = FileSystems.newFileSystem(uri, new HashMap());){
                Path installProfileFile = zipFs.getPath("install_profile.json", new String[0]);
                JsonObject versionInfo = JsonParser.parseReader((Reader)Files.newBufferedReader(installProfileFile)).getAsJsonObject().getAsJsonObject("versionInfo");
                Path versionJsonFile = installDir.resolve(this.versionId + ".json");
                Files.write(versionJsonFile, versionInfo.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                this.parseOldVersionInfo(installDir, versionInfo).stream().filter(parsedLibrary -> !parsedLibrary.isInstalled()).forEach(parsedLibrary -> parsedLibrary.download(this.logger));
            }
            catch (Exception e) {
                this.logger.printStackTrace((Throwable)e);
            }
        }
        Files.deleteIfExists(installerFile);
    }

    private void useInstaller(Path installDir, @NotNull Path installerFile) throws Exception {
        this.logger.info("Launching installer...");
        ModLoaderUtils.fakeContext(installDir, this.vanilla.getName());
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.javaPath);
        command.add("-jar");
        command.add(installerFile.toAbsolutePath().toString());
        command.add("--installClient");
        command.add(installDir.toAbsolutePath().toString());
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(installDir.toFile());
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process process = processBuilder.start();
        process.waitFor();
        Files.copy(installDir.resolve("versions").resolve(this.versionId).resolve(this.versionId + ".json"), installDir.resolve(this.versionId + ".json"), StandardCopyOption.REPLACE_EXISTING);
        ModLoaderUtils.removeFakeContext(installDir);
    }

    @NotNull
    private List<ParsedLibrary> parseOldVersionInfo(Path installDir, @NotNull JsonObject versionInfo) throws Exception {
        ArrayList<ParsedLibrary> parsedLibraries = new ArrayList<ParsedLibrary>();
        JsonArray libraries = versionInfo.getAsJsonArray("libraries");
        for (JsonElement libraryElement : libraries) {
            JsonObject library = libraryElement.getAsJsonObject();
            JsonElement clientreqElem = library.get("clientreq");
            boolean shouldInstall = clientreqElem == null || clientreqElem.getAsBoolean();
            if (!shouldInstall) continue;
            JsonElement urlElem = library.get("url");
            String baseUrl = urlElem == null ? "https://libraries.minecraft.net/" : urlElem.getAsString();
            String completeArtifact = library.get("name").getAsString();
            String[] name = completeArtifact.split(":");
            String group = name[0];
            String artifact = name[1];
            String version = name[2];
            String classifier = artifact.equals("forge") ? "-universal" : "";
            Path libraryPath = ModLoaderUtils.buildLibraryPath(installDir, group, artifact, version);
            String builtJarUrl = ModLoaderUtils.buildJarUrl(baseUrl, group, artifact, version, classifier);
            Callable<String> sha1 = this.getSha1FromLibrary(library, builtJarUrl);
            boolean installed = Files.exists(libraryPath, new LinkOption[0]) && FileUtils.getSHA1((Path)libraryPath).equals(sha1.call());
            parsedLibraries.add(new ParsedLibrary(libraryPath, new URL(builtJarUrl), completeArtifact, installed));
        }
        return parsedLibraries;
    }

    @Override
    public OptiFineInfo getOptiFineInfo() {
        return this.optiFineInfo;
    }

    @Override
    public String name() {
        return "Forge";
    }
}

