/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions.fabric;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.download.json.ModrinthModPackInfo;
import fr.flowarg.flowupdater.download.json.ModrinthVersionInfo;
import fr.flowarg.flowupdater.download.json.OptiFineInfo;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowupdater.utils.ModFileDeleter;
import fr.flowarg.flowupdater.versions.AbstractModLoaderVersion;
import fr.flowarg.flowupdater.versions.ModLoaderUtils;
import fr.flowarg.flowupdater.versions.ParsedLibrary;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public abstract class FabricBasedVersion
extends AbstractModLoaderVersion {
    protected final String metaApi;
    protected String versionId;

    public FabricBasedVersion(String modLoaderVersion, List<Mod> mods, List<CurseFileInfo> curseMods, List<ModrinthVersionInfo> modrinthMods, ModFileDeleter fileDeleter, CurseModPackInfo curseModPackInfo, ModrinthModPackInfo modrinthModPackInfo, OptiFineInfo optiFineInfo, String metaApi) {
        super(modLoaderVersion, mods, curseMods, modrinthMods, fileDeleter, curseModPackInfo, modrinthModPackInfo, optiFineInfo);
        this.metaApi = metaApi;
    }

    @Override
    public boolean isModLoaderAlreadyInstalled(@NotNull Path installDir) {
        Path versionJsonFile = installDir.resolve(this.versionId + ".json");
        if (Files.notExists(versionJsonFile, new LinkOption[0])) {
            return false;
        }
        try {
            return this.parseLibraries(versionJsonFile, installDir).stream().allMatch(ParsedLibrary::isInstalled);
        }
        catch (Exception e) {
            this.logger.err("An error occurred while checking if the mod loader is already installed.");
            return false;
        }
    }

    @Override
    public void install(@NotNull Path installDir) throws Exception {
        super.install(installDir);
        Path versionJsonFile = installDir.resolve(this.versionId + ".json");
        IOUtils.download(this.logger, new URL(String.format(this.metaApi, this.vanilla.getName(), this.modLoaderVersion)), versionJsonFile);
        try {
            List<ParsedLibrary> parsedLibraries = this.parseLibraries(versionJsonFile, installDir);
            parsedLibraries.stream().filter(parsedLibrary -> !parsedLibrary.isInstalled()).forEach(parsedLibrary -> parsedLibrary.download(this.logger));
        }
        catch (Exception e) {
            this.logger.err("An error occurred while installing the mod loader.");
        }
    }

    protected List<ParsedLibrary> parseLibraries(Path versionJsonFile, Path installDir) throws Exception {
        ArrayList<ParsedLibrary> parsedLibraries = new ArrayList<ParsedLibrary>();
        JsonObject object = JsonParser.parseReader((Reader)Files.newBufferedReader(versionJsonFile)).getAsJsonObject();
        JsonArray libraries = object.getAsJsonArray("libraries");
        for (JsonElement libraryElement : libraries) {
            JsonObject library = libraryElement.getAsJsonObject();
            String url = library.get("url").getAsString();
            String completeArtifact = library.get("name").getAsString();
            String[] name = completeArtifact.split(":");
            String group = name[0];
            String artifact = name[1];
            String version = name[2];
            String builtJarUrl = ModLoaderUtils.buildJarUrl(url, group, artifact, version);
            Path builtLibaryPath = ModLoaderUtils.buildLibraryPath(installDir, group, artifact, version);
            Callable<String> sha1 = this.getSha1FromLibrary(library, builtJarUrl);
            boolean installed = Files.exists(builtLibaryPath, new LinkOption[0]) && FileUtils.getSHA1((Path)builtLibaryPath).equalsIgnoreCase(sha1.call());
            parsedLibraries.add(new ParsedLibrary(builtLibaryPath, new URL(builtJarUrl), completeArtifact, installed));
        }
        return parsedLibraries;
    }

    protected Callable<String> getSha1FromLibrary(@NotNull JsonObject library, String builtJarUrl) {
        JsonElement sha1Elem = library.get("sha1");
        if (sha1Elem != null) {
            return () -> ((JsonElement)sha1Elem).getAsString();
        }
        return () -> IOUtils.getContent(new URL(builtJarUrl + ".sha1"));
    }
}

