/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.flowarg.flowstringer.StringUtils;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.json.AssetDownloadable;
import fr.flowarg.flowupdater.download.json.AssetIndex;
import fr.flowarg.flowupdater.download.json.Downloadable;
import fr.flowarg.flowupdater.download.json.MCP;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowupdater.utils.builderapi.BuilderArgument;
import fr.flowarg.flowupdater.utils.builderapi.BuilderException;
import fr.flowarg.flowupdater.utils.builderapi.IBuilder;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class VanillaVersion {
    public static final VanillaVersion NULL_VERSION = new VanillaVersion("no", null, false, null, new ArrayList<AssetDownloadable>(), new ArrayList<Downloadable>(), null);
    private final String name;
    private final MCP mcp;
    private final boolean snapshot;
    private final AssetIndex customAssetIndex;
    private final List<AssetDownloadable> anotherAssets;
    private final List<Downloadable> anotherLibraries;
    private final boolean custom;
    private JsonElement json = null;
    private String jsonURL = null;

    private VanillaVersion(String name, MCP mcp, boolean snapshot, AssetIndex customAssetIndex, List<AssetDownloadable> anotherAssets, List<Downloadable> anotherLibraries, JsonObject customVersionJson) {
        this.name = name;
        this.mcp = mcp;
        this.snapshot = snapshot;
        this.customAssetIndex = customAssetIndex;
        this.anotherAssets = anotherAssets;
        this.anotherLibraries = anotherLibraries;
        boolean bl = this.custom = customVersionJson != null;
        if (!this.name.equals("no")) {
            this.json = customVersionJson == null ? IOUtils.readJson(this.getJsonVersion()) : customVersionJson;
        }
    }

    public JsonArray getMinecraftLibrariesJson() {
        return this.json.getAsJsonObject().getAsJsonArray("libraries");
    }

    public JsonObject getMinecraftClient() {
        if (!this.custom && this.mcp != null) {
            JsonObject result = new JsonObject();
            String sha1 = this.mcp.getClientSha1();
            String url = this.mcp.getClientURL();
            long size = this.mcp.getClientSize();
            if (StringUtils.checkString((String)sha1) && StringUtils.checkString((String)url) && size > 0L) {
                result.addProperty("sha1", sha1);
                result.addProperty("size", (Number)size);
                result.addProperty("url", url);
                return result;
            }
            FlowUpdater.DEFAULT_LOGGER.warn("Skipped MCP Client");
        }
        return this.json.getAsJsonObject().getAsJsonObject("downloads").getAsJsonObject("client");
    }

    public JsonObject getMinecraftAssetIndex() {
        return this.json.getAsJsonObject().getAsJsonObject("assetIndex");
    }

    private InputStream getJsonVersion() {
        AtomicReference<String> version = new AtomicReference<String>(this.getName());
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        try {
            JsonObject launcherMeta = IOUtils.readJson(new URL("https://piston-meta.mojang.com/mc/game/version_manifest_v2.json").openStream()).getAsJsonObject();
            if (this.getName().equals("latest")) {
                JsonObject latest = launcherMeta.getAsJsonObject("latest");
                if (this.snapshot) {
                    version.set(latest.get("snapshot").getAsString());
                } else {
                    version.set(latest.get("release").getAsString());
                }
            }
            launcherMeta.getAsJsonArray("versions").forEach(jsonElement -> {
                if (!jsonElement.getAsJsonObject().get("id").getAsString().equals(version.get())) {
                    return;
                }
                try {
                    this.jsonURL = jsonElement.getAsJsonObject().get("url").getAsString();
                    result.set(new URL(this.jsonURL).openStream());
                }
                catch (Exception e) {
                    FlowUpdater.DEFAULT_LOGGER.printStackTrace((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            FlowUpdater.DEFAULT_LOGGER.printStackTrace((Throwable)e);
        }
        return result.get();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public MCP getMCP() {
        return this.mcp;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public AssetIndex getCustomAssetIndex() {
        return this.customAssetIndex;
    }

    public List<AssetDownloadable> getAnotherAssets() {
        return this.anotherAssets;
    }

    public List<Downloadable> getAnotherLibraries() {
        return this.anotherLibraries;
    }

    public String getJsonURL() {
        return this.jsonURL;
    }

    public static class VanillaVersionBuilder
    implements IBuilder<VanillaVersion> {
        private final BuilderArgument<String> nameArgument = new BuilderArgument("Name").required();
        private final BuilderArgument<MCP> mcpArgument = new BuilderArgument("MCP").optional();
        private final BuilderArgument<Boolean> snapshotArgument = new BuilderArgument<Boolean>("Snapshot", () -> false).optional();
        private final BuilderArgument<AssetIndex> customAssetIndexArgument = new BuilderArgument("CustomAssetIndex").optional();
        private final BuilderArgument<List<AssetDownloadable>> anotherAssetsArgument = new BuilderArgument<List>("AnotherAssets", ArrayList::new).optional();
        private final BuilderArgument<List<Downloadable>> anotherLibrariesArgument = new BuilderArgument<List>("AnotherLibraries", ArrayList::new).optional();
        private final BuilderArgument<JsonObject> customVersionJsonArgument = new BuilderArgument("CustomVersionJson").optional();

        public VanillaVersionBuilder withName(String name) {
            this.nameArgument.set(name);
            return this;
        }

        public VanillaVersionBuilder withMCP(MCP mcp) {
            this.mcpArgument.set(mcp);
            return this;
        }

        public VanillaVersionBuilder withMCP(URL mcpJsonUrl) {
            return this.withMCP(MCP.getMCPFromJson(mcpJsonUrl));
        }

        public VanillaVersionBuilder withMCP(String mcpJsonUrl) {
            return this.withMCP(MCP.getMCPFromJson(mcpJsonUrl));
        }

        public VanillaVersionBuilder withSnapshot(boolean snapshot) {
            this.snapshotArgument.set(snapshot);
            return this;
        }

        public VanillaVersionBuilder withCustomAssetIndex(AssetIndex assetIndex) {
            this.customAssetIndexArgument.set(assetIndex);
            return this;
        }

        public VanillaVersionBuilder withAnotherAssets(Collection<AssetDownloadable> anotherAssets) {
            this.anotherAssetsArgument.get().addAll(anotherAssets);
            return this;
        }

        public VanillaVersionBuilder withAnotherAssets(AssetDownloadable ... anotherAssets) {
            return this.withAnotherAssets(Arrays.asList(anotherAssets));
        }

        public VanillaVersionBuilder withAnotherLibraries(Collection<Downloadable> anotherLibraries) {
            this.anotherLibrariesArgument.get().addAll(anotherLibraries);
            return this;
        }

        public VanillaVersionBuilder withAnotherLibraries(Downloadable ... anotherLibraries) {
            return this.withAnotherLibraries(Arrays.asList(anotherLibraries));
        }

        public VanillaVersionBuilder withCustomVersionJson(JsonObject customVersionJson) {
            this.customVersionJsonArgument.set(customVersionJson);
            return this;
        }

        public VanillaVersionBuilder withCustomVersionJson(URL customVersionJsonUrl) {
            this.customVersionJsonArgument.set(IOUtils.readJson(customVersionJsonUrl).getAsJsonObject());
            return this;
        }

        @Override
        public VanillaVersion build() throws BuilderException {
            return new VanillaVersion(this.nameArgument.get(), this.mcpArgument.get(), this.snapshotArgument.get(), this.customAssetIndexArgument.get(), this.anotherAssetsArgument.get(), this.anotherLibrariesArgument.get(), this.customVersionJsonArgument.get());
        }
    }
}

