/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions;

import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.download.json.ModrinthModPackInfo;
import fr.flowarg.flowupdater.download.json.ModrinthVersionInfo;
import fr.flowarg.flowupdater.utils.ModFileDeleter;
import fr.flowarg.flowupdater.utils.builderapi.BuilderArgument;
import fr.flowarg.flowupdater.utils.builderapi.BuilderException;
import fr.flowarg.flowupdater.utils.builderapi.IBuilder;
import fr.flowarg.flowupdater.versions.IModLoaderVersion;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class ModLoaderVersionBuilder<T extends IModLoaderVersion, B extends ModLoaderVersionBuilder<T, B>>
implements IBuilder<T> {
    protected final BuilderArgument<List<Mod>> modsArgument = new BuilderArgument<List>("Mods", ArrayList::new).optional();
    protected final BuilderArgument<List<CurseFileInfo>> curseModsArgument = new BuilderArgument<List>("CurseMods", ArrayList::new).optional();
    protected final BuilderArgument<List<ModrinthVersionInfo>> modrinthModsArgument = new BuilderArgument<List>("ModrinthMods", ArrayList::new).optional();
    protected final BuilderArgument<ModFileDeleter> fileDeleterArgument = new BuilderArgument<ModFileDeleter>("ModFileDeleter", () -> new ModFileDeleter(false, new String[0])).optional();
    protected final BuilderArgument<CurseModPackInfo> curseModPackArgument = new BuilderArgument("CurseModPack").optional();
    protected final BuilderArgument<ModrinthModPackInfo> modrinthPackArgument = new BuilderArgument("ModrinthModPack").optional();

    public B withMods(List<Mod> mods) {
        this.modsArgument.get().addAll(mods);
        return (B)this;
    }

    public B withMods(Mod ... mods) {
        return this.withMods(Arrays.asList(mods));
    }

    public B withMods(URL jsonUrl) {
        return this.withMods(Mod.getModsFromJson(jsonUrl));
    }

    public B withMods(String jsonUrl) {
        return this.withMods(Mod.getModsFromJson(jsonUrl));
    }

    public B withCurseMods(Collection<CurseFileInfo> curseMods) {
        this.curseModsArgument.get().addAll(curseMods);
        return (B)this;
    }

    public B withCurseMods(CurseFileInfo ... curseMods) {
        return this.withCurseMods(Arrays.asList(curseMods));
    }

    public B withCurseMods(URL jsonUrl) {
        return this.withCurseMods(CurseFileInfo.getFilesFromJson(jsonUrl));
    }

    public B withCurseMods(String jsonUrl) {
        return this.withCurseMods(CurseFileInfo.getFilesFromJson(jsonUrl));
    }

    public B withModrinthMods(Collection<ModrinthVersionInfo> modrinthMods) {
        this.modrinthModsArgument.get().addAll(modrinthMods);
        return (B)this;
    }

    public B withModrinthMods(ModrinthVersionInfo ... modrinthMods) {
        return this.withModrinthMods(Arrays.asList(modrinthMods));
    }

    public B withModrinthMods(URL jsonUrl) {
        return this.withModrinthMods(ModrinthVersionInfo.getModrinthVersionsFromJson(jsonUrl));
    }

    public B withModrinthMods(String jsonUrl) {
        return this.withModrinthMods(ModrinthVersionInfo.getModrinthVersionsFromJson(jsonUrl));
    }

    public B withCurseModPack(CurseModPackInfo modPackInfo) {
        this.curseModPackArgument.set(modPackInfo);
        return (B)this;
    }

    public B withModrinthModPack(ModrinthModPackInfo modPackInfo) {
        this.modrinthPackArgument.set(modPackInfo);
        return (B)this;
    }

    public B withFileDeleter(ModFileDeleter fileDeleter) {
        this.fileDeleterArgument.set(fileDeleter);
        return (B)this;
    }

    @Override
    public abstract T build() throws BuilderException;
}

