/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowupdater.versions.ParsedLibrary;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ModLoaderUtils {
    @Contract(pure=true)
    @NotNull
    public static String buildJarUrl(String baseUrl, @NotNull String group, String artifact, String version) {
        return ModLoaderUtils.buildJarUrl(baseUrl, group, artifact, version, "");
    }

    @Contract(pure=true)
    @NotNull
    public static String buildJarUrl(String baseUrl, @NotNull String group, String artifact, String version, String classifier) {
        return baseUrl + group.replace(".", "/") + "/" + artifact + "/" + version + "/" + artifact + "-" + version + classifier + ".jar";
    }

    @NotNull
    public static Path buildLibraryPath(@NotNull Path installDir, @NotNull String group, String artifact, String version) {
        return installDir.resolve("libraries").resolve(group.replace(".", installDir.getFileSystem().getSeparator())).resolve(artifact).resolve(version).resolve(artifact + "-" + version + ".jar");
    }

    public static void fakeContext(@NotNull Path dirToInstall, String vanilla) throws Exception {
        Path vanillaVersion;
        Path fakeProfiles = dirToInstall.resolve("launcher_profiles.json");
        Files.write(fakeProfiles, "{}".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Path versions = dirToInstall.resolve("versions");
        if (Files.notExists(versions, new LinkOption[0])) {
            Files.createDirectories(versions, new FileAttribute[0]);
        }
        if (Files.notExists(vanillaVersion = versions.resolve(vanilla), new LinkOption[0])) {
            Files.createDirectories(vanillaVersion, new FileAttribute[0]);
        }
        Files.copy(dirToInstall.resolve("client.jar"), vanillaVersion.resolve(vanilla + ".jar"), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void removeFakeContext(@NotNull Path dirToInstall) throws Exception {
        FileUtils.deleteDirectory((Path)dirToInstall.resolve("versions"));
        Files.deleteIfExists(dirToInstall.resolve("launcher_profiles.json"));
    }

    @NotNull
    public static List<ParsedLibrary> parseNewVersionInfo(Path installDir, @NotNull JsonObject versionInfo) throws Exception {
        ArrayList<ParsedLibrary> parsedLibraries = new ArrayList<ParsedLibrary>();
        JsonArray libraries = versionInfo.getAsJsonArray("libraries");
        for (JsonElement libraryElement : libraries) {
            JsonObject library = libraryElement.getAsJsonObject();
            String name = library.get("name").getAsString();
            JsonObject downloads = library.getAsJsonObject("downloads");
            JsonObject artifact = downloads.getAsJsonObject("artifact");
            String path = artifact.get("path").getAsString();
            String sha1 = artifact.get("sha1").getAsString();
            String url = artifact.get("url").getAsString();
            Path libraryPath = installDir.resolve("libraries").resolve(path.replace("/", installDir.getFileSystem().getSeparator()));
            boolean installed = Files.exists(libraryPath, new LinkOption[0]) && FileUtils.getSHA1((Path)libraryPath).equalsIgnoreCase(sha1);
            parsedLibraries.add(new ParsedLibrary(libraryPath, url.isEmpty() ? null : new URL(url), name, installed));
        }
        return parsedLibraries;
    }
}

