/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions;

import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowupdater.utils.ModFileDeleter;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface IModLoaderVersion {
    public void attachFlowUpdater(@NotNull FlowUpdater var1);

    public boolean isModLoaderAlreadyInstalled(@NotNull Path var1);

    default public void install(@NotNull Path installDir) throws Exception {
        this.getCallback().step(Step.MOD_LOADER);
        this.getLogger().info("Installing " + this.name() + ", version: " + this.getModLoaderVersion() + "...");
    }

    public void installMods(@NotNull Path var1) throws Exception;

    public String getModLoaderVersion();

    public List<Mod> getMods();

    default public void installAllMods(@NotNull Path modsDir) {
        this.getDownloadList().getMods().forEach(mod -> {
            try {
                Path modFilePath = modsDir.resolve(mod.getName());
                IOUtils.download(this.getLogger(), new URL(mod.getDownloadURL()), modFilePath);
                this.getCallback().onFileDownloaded(modFilePath);
            }
            catch (Exception e) {
                this.getLogger().printStackTrace((Throwable)e);
            }
            this.getDownloadList().incrementDownloaded(mod.getSize());
            this.getCallback().update(this.getDownloadList().getDownloadInfo());
        });
    }

    public DownloadList getDownloadList();

    public ILogger getLogger();

    public IProgressCallback getCallback();

    public ModFileDeleter getFileDeleter();

    public String name();
}

