/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.utils;

import fr.flowarg.flowupdater.utils.ExternalFileDeleter;
import fr.flowarg.flowupdater.utils.builderapi.BuilderArgument;
import fr.flowarg.flowupdater.utils.builderapi.BuilderException;
import fr.flowarg.flowupdater.utils.builderapi.IBuilder;
import java.nio.file.Paths;

public class UpdaterOptions {
    public static final UpdaterOptions DEFAULT = new UpdaterOptions(new ExternalFileDeleter(), true, System.getProperty("java.home") != null ? Paths.get(System.getProperty("java.home"), new String[0]).resolve("bin").resolve("java").toAbsolutePath().toString() : "java");
    private final ExternalFileDeleter externalFileDeleter;
    private final boolean versionChecker;
    private final String javaPath;

    private UpdaterOptions(ExternalFileDeleter externalFileDeleter, boolean versionChecker, String javaPath) {
        this.externalFileDeleter = externalFileDeleter;
        this.versionChecker = versionChecker;
        this.javaPath = javaPath;
    }

    public ExternalFileDeleter getExternalFileDeleter() {
        return this.externalFileDeleter;
    }

    public boolean isVersionChecker() {
        return this.versionChecker;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public static class UpdaterOptionsBuilder
    implements IBuilder<UpdaterOptions> {
        private final BuilderArgument<ExternalFileDeleter> externalFileDeleterArgument = new BuilderArgument<ExternalFileDeleter>("External FileDeleter", ExternalFileDeleter::new).optional();
        private final BuilderArgument<Boolean> versionChecker = new BuilderArgument<Boolean>("VersionChecker", () -> true).optional();
        private final BuilderArgument<String> javaPath = new BuilderArgument<String>("JavaPath", () -> System.getProperty("java.home") != null ? Paths.get(System.getProperty("java.home"), new String[0]).resolve("bin").resolve("java").toAbsolutePath().toString() : "java").optional();

        public UpdaterOptionsBuilder withExternalFileDeleter(ExternalFileDeleter externalFileDeleter) {
            this.externalFileDeleterArgument.set(externalFileDeleter);
            return this;
        }

        public UpdaterOptionsBuilder withVersionChecker(boolean versionChecker) {
            this.versionChecker.set(versionChecker);
            return this;
        }

        public UpdaterOptionsBuilder withJavaPath(String javaPath) {
            this.javaPath.set(javaPath);
            return this;
        }

        @Override
        public UpdaterOptions build() throws BuilderException {
            return new UpdaterOptions(this.externalFileDeleterArgument.get(), this.versionChecker.get(), this.javaPath.get());
        }
    }
}

