/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.utils;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.integrations.modrinthintegration.ModrinthModPack;
import fr.flowarg.flowupdater.integrations.optifineintegration.OptiFine;
import fr.flowarg.flowupdater.utils.IFileDeleter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ModFileDeleter
implements IFileDeleter {
    private final boolean useFileDeleter;
    private final String[] modsToIgnore;
    private final Pattern modsToIgnorePattern;

    public ModFileDeleter(boolean useFileDeleter, String ... modsToIgnore) {
        this.useFileDeleter = useFileDeleter;
        this.modsToIgnore = modsToIgnore;
        this.modsToIgnorePattern = null;
    }

    public ModFileDeleter(String ... modsToIgnore) {
        this(true, modsToIgnore);
    }

    public ModFileDeleter(boolean useFileDeleter, Pattern modsToIgnorePattern) {
        this.useFileDeleter = useFileDeleter;
        this.modsToIgnore = null;
        this.modsToIgnorePattern = modsToIgnorePattern;
    }

    public ModFileDeleter(Pattern modsToIgnorePattern) {
        this(true, modsToIgnorePattern);
    }

    public void delete(ILogger logger, Path modsDir, List<Mod> mods, OptiFine optiFine, ModrinthModPack modrinthModPack) throws Exception {
        if (!this.isUseFileDeleter()) {
            return;
        }
        HashSet<Path> badFiles = new HashSet<Path>();
        ArrayList<Path> verifiedFiles = new ArrayList<Path>();
        if (this.modsToIgnore != null) {
            Arrays.stream(this.modsToIgnore).forEach(fileName -> verifiedFiles.add(modsDir.resolve((String)fileName)));
        } else if (this.modsToIgnorePattern != null) {
            FileUtils.list((Path)modsDir).stream().filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                if (this.modsToIgnorePattern.matcher(path.getFileName().toString()).matches()) {
                    verifiedFiles.add((Path)path);
                }
            });
        }
        if (modrinthModPack != null) {
            modrinthModPack.getBuiltInMods().forEach(mod -> verifiedFiles.add(modsDir.resolve(mod.getName())));
        }
        for (Path fileInDir : FileUtils.list((Path)modsDir).stream().filter(path -> !Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toList())) {
            if (verifiedFiles.contains(fileInDir)) continue;
            if (mods.isEmpty() && optiFine == null) {
                if (verifiedFiles.contains(fileInDir)) continue;
                badFiles.add(fileInDir);
                continue;
            }
            if (optiFine != null) {
                if (optiFine.getName().equalsIgnoreCase(fileInDir.getFileName().toString())) {
                    if (Files.size(fileInDir) == optiFine.getSize()) {
                        badFiles.remove(fileInDir);
                        verifiedFiles.add(fileInDir);
                    } else {
                        badFiles.add(fileInDir);
                    }
                } else if (!verifiedFiles.contains(fileInDir)) {
                    badFiles.add(fileInDir);
                }
            }
            for (Mod mod2 : mods) {
                if (mod2.getName().equalsIgnoreCase(fileInDir.getFileName().toString())) {
                    if (Files.size(fileInDir) == mod2.getSize() && (mod2.getSha1().isEmpty() || FileUtils.getSHA1((Path)fileInDir).equalsIgnoreCase(mod2.getSha1()))) {
                        badFiles.remove(fileInDir);
                        verifiedFiles.add(fileInDir);
                        continue;
                    }
                    badFiles.add(fileInDir);
                    continue;
                }
                if (verifiedFiles.contains(fileInDir)) continue;
                badFiles.add(fileInDir);
            }
        }
        badFiles.forEach(path -> {
            try {
                Files.deleteIfExists(path);
            }
            catch (Exception e) {
                logger.printStackTrace((Throwable)e);
            }
        });
        badFiles.clear();
    }

    public boolean isUseFileDeleter() {
        return this.useFileDeleter;
    }

    public String[] getModsToIgnore() {
        return this.modsToIgnore;
    }
}

