/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import fr.flowarg.flowcompat.Platform;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IOUtils {
    private static Path cachedMinecraftPath = null;
    private static final Map<String, Integer> DOWNLOAD_RETRIES_CAUSED_BY_SSL_HANDSHAKE_EXCEPTION = new HashMap<String, Integer>();

    public static void download(@NotNull ILogger logger, @NotNull URL in, @NotNull Path out) {
        String url = in.toExternalForm();
        try {
            logger.info(String.format("Downloading %s from %s...", out.getFileName().toString(), url));
            Files.createDirectories(out.toAbsolutePath().getParent(), new FileAttribute[0]);
            Files.copy(IOUtils.catchForbidden(in), out, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (SSLHandshakeException e) {
            if (DOWNLOAD_RETRIES_CAUSED_BY_SSL_HANDSHAKE_EXCEPTION.getOrDefault(url, 0) > 3) {
                logger.err("Too many retries caused by SSLHandshakeException when downloading file from: " + url);
                logger.printStackTrace((Throwable)e);
                DOWNLOAD_RETRIES_CAUSED_BY_SSL_HANDSHAKE_EXCEPTION.remove(url);
                return;
            }
            IOUtils.download(logger, in, out);
            DOWNLOAD_RETRIES_CAUSED_BY_SSL_HANDSHAKE_EXCEPTION.put(url, DOWNLOAD_RETRIES_CAUSED_BY_SSL_HANDSHAKE_EXCEPTION.getOrDefault(url, 0) + 1);
        }
        catch (Exception e) {
            logger.printStackTrace((Throwable)e);
        }
    }

    public static void copy(@NotNull ILogger logger, @NotNull Path in, @NotNull Path out) {
        try {
            logger.info(String.format("Copying %s to %s...", in, out));
            Files.createDirectories(out.getParent(), new FileAttribute[0]);
            Files.copy(in, out, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            logger.printStackTrace((Throwable)e);
        }
    }

    @NotNull
    public static String getContent(URL url) {
        try {
            return IOUtils.getContent(IOUtils.catchForbidden(url));
        }
        catch (Exception e) {
            FlowUpdater.DEFAULT_LOGGER.printStackTrace((Throwable)e);
            return "";
        }
    }

    @NotNull
    public static String getContent(InputStream remote) {
        StringBuilder sb = new StringBuilder();
        try (BufferedInputStream stream = new BufferedInputStream(remote);){
            int character;
            ReadableByteChannel rbc = Channels.newChannel(stream);
            Reader enclosedReader = Channels.newReader(rbc, StandardCharsets.UTF_8.newDecoder(), -1);
            BufferedReader reader = new BufferedReader(enclosedReader);
            while ((character = reader.read()) != -1) {
                sb.append((char)character);
            }
            reader.close();
            enclosedReader.close();
            rbc.close();
        }
        catch (Exception e) {
            FlowUpdater.DEFAULT_LOGGER.printStackTrace((Throwable)e);
        }
        return sb.toString();
    }

    public static JsonElement readJson(URL jsonURL) {
        try {
            return IOUtils.readJson(IOUtils.catchForbidden(jsonURL));
        }
        catch (Exception e) {
            FlowUpdater.DEFAULT_LOGGER.printStackTrace((Throwable)e);
            return JsonNull.INSTANCE;
        }
    }

    public static JsonElement readJson(InputStream inputStream) {
        JsonNull element = JsonNull.INSTANCE;
        try (BufferedInputStream stream = new BufferedInputStream(inputStream);){
            int character;
            ReadableByteChannel rbc = Channels.newChannel(stream);
            Reader enclosedReader = Channels.newReader(rbc, StandardCharsets.UTF_8.newDecoder(), -1);
            BufferedReader reader = new BufferedReader(enclosedReader);
            StringBuilder sb = new StringBuilder();
            while ((character = reader.read()) != -1) {
                sb.append((char)character);
            }
            element = JsonParser.parseString((String)sb.toString());
            reader.close();
            enclosedReader.close();
            rbc.close();
        }
        catch (Exception e) {
            FlowUpdater.DEFAULT_LOGGER.printStackTrace((Throwable)e);
        }
        return element.getAsJsonObject();
    }

    public static InputStream catchForbidden(@NotNull URL url) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
        connection.setInstanceFollowRedirects(true);
        return connection.getInputStream();
    }

    public static <T> void executeAsyncForEach(@NotNull Iterable<T> iterable, @NotNull ExecutorService service, Consumer<T> runnable) {
        try {
            iterable.forEach(t -> service.submit(() -> runnable.accept(t)));
            service.shutdown();
            service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new FlowUpdaterException(e);
        }
    }

    @Nullable
    public static String getLatestArtifactVersion(String mavenMetadataUrl) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new URL(mavenMetadataUrl).openStream());
            return IOUtils.getLatestArtifactVersion(doc);
        }
        catch (Exception e) {
            FlowUpdater.DEFAULT_LOGGER.printStackTrace((Throwable)e);
            return null;
        }
    }

    public static String getLatestArtifactVersion(@NotNull Document doc) {
        doc.getDocumentElement().normalize();
        Element root = doc.getDocumentElement();
        NodeList nList = root.getElementsByTagName("versioning");
        String version = "";
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node node = nList.item(temp);
            if (node.getNodeType() != 1) continue;
            version = ((Element)node).getElementsByTagName("release").item(0).getTextContent();
        }
        return version;
    }

    public static Path getMinecraftFolder() {
        return cachedMinecraftPath == null ? (cachedMinecraftPath = Paths.get(Platform.isOnWindows() ? System.getenv("APPDATA") : (Platform.isOnMac() ? System.getProperty("user.home") + "/Library/Application Support/" : System.getProperty("user.home")), ".minecraft")) : cachedMinecraftPath;
    }
}

