/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.integrations.modrinthintegration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowstringer.StringUtils;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.download.json.ModrinthModPackInfo;
import fr.flowarg.flowupdater.download.json.ModrinthVersionInfo;
import fr.flowarg.flowupdater.integrations.Integration;
import fr.flowarg.flowupdater.integrations.modrinthintegration.ModrinthModPack;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModrinthIntegration
extends Integration {
    private static final String MODRINTH_URL = "https://api.modrinth.com/v2/";
    private static final String MODRINTH_VERSION_ENDPOINT = "version/{versionId}";
    private static final String MODRINTH_PROJECT_VERSION_ENDPOINT = "project/{projectId}/version";
    private final List<Mod> builtInMods = new ArrayList<Mod>();

    public ModrinthIntegration(ILogger logger, Path folder) throws Exception {
        super(logger, folder);
    }

    public Mod fetchMod(@NotNull ModrinthVersionInfo versionInfo) throws Exception {
        if (!versionInfo.getVersionId().isEmpty()) {
            URL url = new URL(MODRINTH_URL + MODRINTH_VERSION_ENDPOINT.replace("{versionId}", versionInfo.getVersionId()));
            return this.parseModFile(JsonParser.parseString((String)IOUtils.getContent(url)).getAsJsonObject());
        }
        URL url = new URL(MODRINTH_URL + MODRINTH_PROJECT_VERSION_ENDPOINT.replace("{projectId}", versionInfo.getProjectReference()));
        JsonArray versions = JsonParser.parseString((String)IOUtils.getContent(url)).getAsJsonArray();
        JsonObject version = null;
        for (JsonElement jsonElement : versions) {
            if (!jsonElement.getAsJsonObject().get("version_number").getAsString().equals(versionInfo.getVersionNumber())) continue;
            version = jsonElement.getAsJsonObject();
            break;
        }
        if (version == null) {
            throw new FlowUpdaterException("No version found for " + versionInfo.getVersionNumber() + " in project " + versionInfo.getProjectReference());
        }
        return this.parseModFile(version);
    }

    public Mod parseModFile(@NotNull JsonObject version) {
        JsonObject fileJson = version.getAsJsonArray("files").get(0).getAsJsonObject();
        String fileName = fileJson.get("filename").getAsString();
        String downloadURL = fileJson.get("url").getAsString();
        String sha1 = fileJson.getAsJsonObject("hashes").get("sha1").getAsString();
        long size = fileJson.get("size").getAsLong();
        return new Mod(fileName, downloadURL, sha1, size);
    }

    public ModrinthModPack getCurseModPack(ModrinthModPackInfo info) throws Exception {
        Path modPackFile = this.checkForUpdate(info);
        if (modPackFile == null) {
            throw new FlowUpdaterException("Can't find the mod pack file with the provided Modrinth mod pack info.");
        }
        this.extractModPack(modPackFile, info.isInstallExtFiles());
        return this.parseMods();
    }

    @Nullable
    private Path checkForUpdate(@NotNull ModrinthModPackInfo info) throws Exception {
        Mod modPackFile = this.fetchMod(info);
        if (modPackFile == null) {
            this.logger.err("This mod pack isn't available anymore on Modrinth (for 3rd parties maybe). ");
            return null;
        }
        Path outPath = this.folder.resolve(modPackFile.getName());
        if (Files.notExists(outPath, new LinkOption[0]) || !FileUtils.getSHA1((Path)outPath).equalsIgnoreCase(modPackFile.getSha1())) {
            IOUtils.download(this.logger, new URL(modPackFile.getDownloadURL()), outPath);
        }
        return outPath;
    }

    private void extractModPack(@NotNull Path out, boolean installExtFiles) throws Exception {
        this.logger.info("Extracting mod pack...");
        ZipFile zipFile = new ZipFile(out.toFile(), 1, StandardCharsets.UTF_8);
        Path dirPath = this.folder.getParent();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            Path flPath = dirPath.resolve(StringUtils.empty((String)StringUtils.empty((String)entryName, (String)"client-overrides/"), (String)"overrides/"));
            if (entryName.equalsIgnoreCase("modrinth.index.json")) {
                if (!Files.notExists(flPath, new LinkOption[0]) && entry.getCrc() == FileUtils.getCRC32((Path)flPath)) continue;
                this.transferAndClose(flPath, zipFile, entry);
                continue;
            }
            String withoutOverrides = StringUtils.empty((String)StringUtils.empty((String)entryName, (String)"overrides/"), (String)"client-overrides/");
            if (withoutOverrides.startsWith("mods/") || withoutOverrides.startsWith("mods\\")) {
                String modName = withoutOverrides.substring(withoutOverrides.lastIndexOf(47) + 1);
                Mod mod = new Mod(modName, "", "", entry.getSize());
                this.builtInMods.add(mod);
            }
            if (!installExtFiles || Files.exists(flPath, new LinkOption[0])) continue;
            if (flPath.getFileName().toString().endsWith(flPath.getFileSystem().getSeparator())) {
                Files.createDirectories(flPath, new FileAttribute[0]);
            }
            if (entry.isDirectory()) continue;
            this.transferAndClose(flPath, zipFile, entry);
        }
        zipFile.close();
    }

    @NotNull
    private ModrinthModPack parseMods() throws Exception {
        this.logger.info("Fetching mods...");
        Path dirPath = this.folder.getParent();
        String manifestJson = StringUtils.toString(Files.readAllLines(dirPath.resolve("modrinth.index.json")));
        JsonObject manifestObj = JsonParser.parseString((String)manifestJson).getAsJsonObject();
        String modPackName = manifestObj.get("name").getAsString();
        String modPackVersion = manifestObj.get("versionId").getAsString();
        List<Mod> mods = this.parseManifest(manifestObj);
        return new ModrinthModPack(modPackName, modPackVersion, mods, this.builtInMods);
    }

    @NotNull
    private List<Mod> parseManifest(@NotNull JsonObject manifestObject) {
        ArrayList<Mod> mods = new ArrayList<Mod>();
        JsonArray files = manifestObject.getAsJsonArray("files");
        files.forEach(jsonElement -> {
            JsonObject file = jsonElement.getAsJsonObject();
            if (file.getAsJsonObject("env").get("client").getAsString().equals("unsupported")) {
                return;
            }
            String name = StringUtils.empty((String)StringUtils.empty((String)file.get("path").getAsString(), (String)"mods/"), (String)"mods\\");
            String downloadURL = file.getAsJsonArray("downloads").get(0).getAsString();
            String sha1 = file.getAsJsonObject("hashes").get("sha1").getAsString();
            long size = file.get("fileSize").getAsLong();
            mods.add(new Mod(name, downloadURL, sha1, size));
        });
        return mods;
    }

    private void transferAndClose(@NotNull Path flPath, ZipFile zipFile, ZipEntry entry) throws Exception {
        if (Files.notExists(flPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(flPath.getParent(), new FileAttribute[0]);
        }
        Files.copy(zipFile.getInputStream(entry), flPath, StandardCopyOption.REPLACE_EXISTING);
    }
}

