/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.integrations.curseforgeintegration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowstringer.StringUtils;
import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.integrations.Integration;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseModPack;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CurseForgeIntegration
extends Integration {
    private static final String CF_API_URL = "https://api.curseforge.com";
    private static final String CF_API_KEY = "JDJhJDEwJHBFZjhacXFwWE4zbVdtLm5aZ2pBMC5kdm9ibnhlV3hQZWZma2Q5ZEhCRWFid2VaUWh2cUtpJDJhJ";
    private static final String MOD_FILE_ENDPOINT = "/v1/mods/{modId}/files/{fileId}";
    private boolean manifestChanged = false;
    private static String cacheKey = "";

    public CurseForgeIntegration(ILogger logger, Path folder) throws Exception {
        super(logger, folder);
    }

    public Mod fetchMod(CurseFileInfo curseFileInfo) throws CurseForgeException {
        try {
            return this.parseModFile(this.fetchModLink(curseFileInfo));
        }
        catch (Exception e) {
            throw new CurseForgeException(String.format("Failed to fetch mod project id: %d file id: %d", curseFileInfo.getProjectID(), curseFileInfo.getFileID()), e);
        }
    }

    public String fetchModLink(@NotNull CurseFileInfo curseFileInfo) {
        String url = CF_API_URL + MOD_FILE_ENDPOINT.replace("{modId}", String.valueOf(curseFileInfo.getProjectID())).replace("{fileId}", String.valueOf(curseFileInfo.getFileID()));
        return this.makeRequest(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String makeRequest(String url) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            connection.setInstanceFollowRedirects(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("x-api-key", this.getCurseForgeAPIKey());
            String string = IOUtils.getContent(connection.getInputStream());
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @NotNull
    private Mod parseModFile(String jsonResponse) {
        String downloadURL;
        JsonObject data = JsonParser.parseString((String)jsonResponse).getAsJsonObject().getAsJsonObject("data");
        String fileName = data.get("fileName").getAsString();
        JsonElement downloadURLElement = data.get("downloadUrl");
        if (downloadURLElement instanceof JsonNull) {
            this.logger.warn(String.format("Mod file %s not available. The download can fail because of this! %s", data.get("displayName").getAsString(), jsonResponse));
            String id = Integer.toString(data.get("id").getAsInt());
            downloadURL = String.format("https://mediafiles.forgecdn.net/files/%s/%s/%s", id.substring(0, 4), id.substring(4), fileName);
        } else {
            downloadURL = downloadURLElement.getAsString();
        }
        long fileLength = data.get("fileLength").getAsLong();
        AtomicReference<String> sha1 = new AtomicReference<String>("");
        data.getAsJsonArray("hashes").forEach(hashObject -> {
            String hash = hashObject.getAsJsonObject().get("value").getAsString();
            if (hash.length() == 40) {
                sha1.set(hash);
            }
        });
        return new Mod(fileName, downloadURL, sha1.get(), fileLength);
    }

    public CurseModPack getCurseModPack(CurseModPackInfo info) throws Exception {
        Path modPackFile = this.checkForUpdate(info);
        this.extractModPack(modPackFile, info.isInstallExtFiles());
        return this.parseMods();
    }

    @NotNull
    private Path checkForUpdate(@NotNull CurseModPackInfo info) throws Exception {
        String responseData = info.getUrl().isEmpty() ? this.fetchModLink(info) : this.makeRequest(info.getUrl());
        Mod modPackFile = this.parseModFile(responseData);
        Path outPath = this.folder.resolve(modPackFile.getName());
        if (Files.notExists(outPath, new LinkOption[0]) || !modPackFile.getSha1().isEmpty() && !FileUtils.getSHA1((Path)outPath).equalsIgnoreCase(modPackFile.getSha1()) || Files.size(outPath) != modPackFile.getSize()) {
            IOUtils.download(this.logger, new URL(modPackFile.getDownloadURL()), outPath);
        }
        return outPath;
    }

    private void extractModPack(@NotNull Path out, boolean installExtFiles) throws Exception {
        this.logger.info("Extracting mod pack...");
        ZipFile zipFile = new ZipFile(out.toFile(), 1, StandardCharsets.UTF_8);
        Path dirPath = this.folder.getParent();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            Path flPath = dirPath.resolve(StringUtils.empty((String)entry.getName(), (String)"overrides/"));
            String entryName = entry.getName();
            if (entryName.equalsIgnoreCase("manifest.json")) {
                if (Files.notExists(flPath, new LinkOption[0]) || entry.getCrc() != FileUtils.getCRC32((Path)flPath)) {
                    this.manifestChanged = true;
                    this.transferAndClose(flPath, zipFile, entry);
                }
                if (installExtFiles) continue;
                break;
            }
            if (!installExtFiles || entryName.equals("modlist.html")) continue;
            if (Files.exists(flPath, new LinkOption[0])) {
                if (!Files.isDirectory(flPath, new LinkOption[0]) && entry.getCrc() == FileUtils.getCRC32((Path)flPath)) {
                    continue;
                }
            } else if (flPath.getFileName().toString().endsWith(flPath.getFileSystem().getSeparator())) {
                Files.createDirectories(flPath, new FileAttribute[0]);
            }
            if (entry.isDirectory()) continue;
            this.transferAndClose(flPath, zipFile, entry);
        }
        zipFile.close();
    }

    @NotNull
    private CurseModPack parseMods() throws Exception {
        this.logger.info("Fetching mods...");
        Path dirPath = this.folder.getParent();
        String manifestJson = StringUtils.toString(Files.readAllLines(dirPath.resolve("manifest.json")));
        JsonObject manifestObj = JsonParser.parseString((String)manifestJson).getAsJsonObject();
        String modPackName = manifestObj.get("name").getAsString();
        String modPackVersion = manifestObj.get("version").getAsString();
        String modPackAuthor = manifestObj.get("author").getAsString();
        List<CurseModPack.CurseModPackMod> mods = this.processCacheFile(dirPath, this.populateManifest(manifestObj));
        return new CurseModPack(modPackName, modPackVersion, modPackAuthor, mods);
    }

    @NotNull
    private List<ProjectMod> populateManifest(@NotNull JsonObject manifestObj) {
        ArrayList<ProjectMod> manifestFiles = new ArrayList<ProjectMod>();
        manifestObj.getAsJsonArray("files").forEach(jsonElement -> manifestFiles.add(ProjectMod.fromJson(jsonElement.getAsJsonObject())));
        return manifestFiles;
    }

    @NotNull
    private List<CurseModPack.CurseModPackMod> processCacheFile(@NotNull Path dirPath, List<ProjectMod> manifestFiles) throws Exception {
        Path cachePath = dirPath.resolve("manifest.cache.json");
        if (Files.notExists(cachePath, new LinkOption[0])) {
            Files.createFile(cachePath, new FileAttribute[0]);
            Files.write(cachePath, Collections.singletonList("[]"), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        String json = StringUtils.toString(Files.readAllLines(cachePath, StandardCharsets.UTF_8));
        if (this.manifestChanged || json.contains("\"md5\"") || json.contains("\"length\"")) {
            Files.delete(cachePath);
            Files.createFile(cachePath, new FileAttribute[0]);
            Files.write(cachePath, Collections.singletonList("[]"), StandardCharsets.UTF_8, new OpenOption[0]);
            json = StringUtils.toString(Files.readAllLines(cachePath, StandardCharsets.UTF_8));
        }
        return this.deserializeWriteCache(json, manifestFiles, cachePath);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    private List<CurseModPack.CurseModPackMod> deserializeWriteCache(String json, List<ProjectMod> manifestFiles, Path cachePath) throws Exception {
        JsonArray cacheArray = JsonParser.parseString((String)json).getAsJsonArray();
        ConcurrentLinkedQueue mods = new ConcurrentLinkedQueue();
        cacheArray.forEach(jsonElement -> {
            JsonObject object = jsonElement.getAsJsonObject();
            Mod mod = Mod.fromJson(jsonElement);
            ProjectMod projectMod = ProjectMod.fromJson(object);
            mods.add(new CurseModPack.CurseModPackMod(mod, projectMod.isRequired()));
            manifestFiles.remove(projectMod);
        });
        IOUtils.executeAsyncForEach(manifestFiles, Executors.newWorkStealingPool(), projectMod -> this.fetchAndSerializeProjectMod((ProjectMod)projectMod, cacheArray, mods));
        Files.write(cachePath, Collections.singletonList(cacheArray.toString()), StandardCharsets.UTF_8, new OpenOption[0]);
        return new ArrayList<CurseModPack.CurseModPackMod>(mods);
    }

    private void fetchAndSerializeProjectMod(@NotNull ProjectMod projectMod, JsonArray cacheArray, Queue<CurseModPack.CurseModPackMod> mods) {
        boolean required = projectMod.isRequired();
        try {
            Mod retrievedMod = this.fetchMod(projectMod);
            if (retrievedMod == null) {
                return;
            }
            CurseModPack.CurseModPackMod mod = new CurseModPack.CurseModPackMod(retrievedMod, required);
            JsonObject inCache = new JsonObject();
            inCache.addProperty("name", mod.getName());
            inCache.addProperty("downloadURL", mod.getDownloadURL());
            inCache.addProperty("sha1", mod.getSha1());
            inCache.addProperty("size", (Number)mod.getSize());
            inCache.addProperty("required", Boolean.valueOf(required));
            inCache.addProperty("projectID", (Number)projectMod.getProjectID());
            inCache.addProperty("fileID", (Number)projectMod.getFileID());
            cacheArray.add((JsonElement)inCache);
            mods.add(mod);
        }
        catch (Exception e) {
            this.logger.printStackTrace((Throwable)e);
        }
    }

    private void transferAndClose(@NotNull Path flPath, ZipFile zipFile, ZipEntry entry) throws Exception {
        if (Files.notExists(flPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(flPath.getParent(), new FileAttribute[0]);
        }
        Files.copy(zipFile.getInputStream(entry), flPath, StandardCopyOption.REPLACE_EXISTING);
    }

    private String getCurseForgeAPIKey() {
        return cacheKey.isEmpty() ? (cacheKey = StringUtils.toString((byte[])Base64.getDecoder().decode(CF_API_KEY.substring(0, CF_API_KEY.length() - 5)))) : cacheKey;
    }

    private static class ProjectMod
    extends CurseFileInfo {
        private final boolean required;

        public ProjectMod(int projectID, int fileID, boolean required) {
            super(projectID, fileID);
            this.required = required;
        }

        @NotNull
        private static ProjectMod fromJson(@NotNull JsonObject object) {
            return new ProjectMod(object.get("projectID").getAsInt(), object.get("fileID").getAsInt(), object.get("required").getAsBoolean());
        }

        public boolean isRequired() {
            return this.required;
        }
    }

    public static class CurseForgeException
    extends Exception {
        public CurseForgeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

