/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.integrations;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.download.json.ModrinthModPackInfo;
import fr.flowarg.flowupdater.download.json.ModrinthVersionInfo;
import fr.flowarg.flowupdater.download.json.OptiFineInfo;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseForgeIntegration;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseModPack;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.ICurseForgeCompatible;
import fr.flowarg.flowupdater.integrations.modrinthintegration.IModrinthCompatible;
import fr.flowarg.flowupdater.integrations.modrinthintegration.ModrinthIntegration;
import fr.flowarg.flowupdater.integrations.modrinthintegration.ModrinthModPack;
import fr.flowarg.flowupdater.integrations.optifineintegration.IOptiFineCompatible;
import fr.flowarg.flowupdater.integrations.optifineintegration.OptiFine;
import fr.flowarg.flowupdater.integrations.optifineintegration.OptiFineIntegration;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IntegrationManager {
    private final IProgressCallback progressCallback;
    private final ILogger logger;
    private final DownloadList downloadList;

    public IntegrationManager(@NotNull FlowUpdater updater) {
        this.progressCallback = updater.getCallback();
        this.logger = updater.getLogger();
        this.downloadList = updater.getDownloadList();
    }

    public void loadCurseForgeIntegration(Path dir, ICurseForgeCompatible curseForgeCompatible) {
        this.progressCallback.step(Step.INTEGRATION);
        try {
            CurseModPackInfo modPackInfo = curseForgeCompatible.getCurseModPackInfo();
            ArrayList<Mod> allCurseMods = new ArrayList<Mod>();
            if (curseForgeCompatible.getCurseMods().isEmpty() && modPackInfo == null) {
                curseForgeCompatible.setAllCurseMods(allCurseMods);
                return;
            }
            CurseForgeIntegration curseForgeIntegration = new CurseForgeIntegration(this.logger, dir.getParent().resolve(".cfp"));
            for (CurseFileInfo info : curseForgeCompatible.getCurseMods()) {
                try {
                    Mod mod2 = curseForgeIntegration.fetchMod(info);
                    if (mod2 == null) break;
                    this.checkMod(mod2, allCurseMods, dir);
                }
                catch (Exception e) {
                    this.logger.printStackTrace((Throwable)e);
                }
            }
            if (modPackInfo == null) {
                curseForgeCompatible.setAllCurseMods(allCurseMods);
                return;
            }
            this.progressCallback.step(Step.MOD_PACK);
            CurseModPack modPack = curseForgeIntegration.getCurseModPack(modPackInfo);
            this.logger.info(String.format("Loading mod pack: %s (%s) by %s.", modPack.getName(), modPack.getVersion(), modPack.getAuthor()));
            modPack.getMods().forEach(mod -> {
                allCurseMods.add((Mod)mod);
                try {
                    Path filePath = dir.resolve(mod.getName());
                    boolean flag = false;
                    for (String exclude : modPackInfo.getExcluded()) {
                        if (!mod.getName().equalsIgnoreCase(exclude)) continue;
                        flag = !mod.isRequired();
                        break;
                    }
                    if (flag) {
                        return;
                    }
                    if (Files.exists(filePath, new LinkOption[0]) && Files.size(filePath) == mod.getSize() && (mod.getSha1().isEmpty() || FileUtils.getSHA1((Path)filePath).equalsIgnoreCase(mod.getSha1()))) {
                        return;
                    }
                    Files.deleteIfExists(filePath);
                    this.downloadList.getMods().add((Mod)mod);
                }
                catch (Exception e) {
                    this.logger.printStackTrace((Throwable)e);
                }
            });
            curseForgeCompatible.setAllCurseMods(allCurseMods);
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    public void loadModrinthIntegration(Path dir, IModrinthCompatible modrinthCompatible) {
        try {
            ModrinthModPackInfo modPackInfo = modrinthCompatible.getModrinthModPackInfo();
            ArrayList<Mod> allModrinthMods = new ArrayList<Mod>();
            if (modrinthCompatible.getModrinthMods().isEmpty() && modPackInfo == null) {
                modrinthCompatible.setAllModrinthMods(allModrinthMods);
                return;
            }
            ModrinthIntegration modrinthIntegration = new ModrinthIntegration(this.logger, dir.getParent().resolve(".modrinth"));
            for (ModrinthVersionInfo info : modrinthCompatible.getModrinthMods()) {
                Mod mod = modrinthIntegration.fetchMod(info);
                this.checkMod(mod, allModrinthMods, dir);
            }
            if (modPackInfo == null) {
                modrinthCompatible.setAllModrinthMods(allModrinthMods);
                return;
            }
            this.progressCallback.step(Step.MOD_PACK);
            ModrinthModPack modPack = modrinthIntegration.getCurseModPack(modPackInfo);
            this.logger.info(String.format("Loading mod pack: %s (%s).", modPack.getName(), modPack.getVersion()));
            modrinthCompatible.setModrinthModPack(modPack);
            for (Mod mod : modPack.getMods()) {
                this.checkMod(mod, allModrinthMods, dir);
            }
            modrinthCompatible.setAllModrinthMods(allModrinthMods);
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    public void loadOptiFineIntegration(Path dir, @NotNull IOptiFineCompatible optiFineCompatible) {
        OptiFineInfo info = optiFineCompatible.getOptiFineInfo();
        if (info == null) {
            return;
        }
        try {
            OptiFineIntegration optifineIntegration = new OptiFineIntegration(this.logger, dir.getParent().resolve(".op"));
            OptiFine optifine = optifineIntegration.getOptiFine(info.getVersion(), info.isPreview());
            this.downloadList.setOptiFine(optifine);
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    private void checkMod(Mod mod, @NotNull List<Mod> allMods, @NotNull Path dir) throws Exception {
        allMods.add(mod);
        Path filePath = dir.resolve(mod.getName());
        if (Files.exists(filePath, new LinkOption[0]) && Files.size(filePath) == mod.getSize() && (mod.getSha1().isEmpty() || FileUtils.getSHA1((Path)filePath).equalsIgnoreCase(mod.getSha1()))) {
            return;
        }
        Files.deleteIfExists(filePath);
        this.downloadList.getMods().add(mod);
    }
}

