/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModrinthVersionInfo {
    private String projectReference = "";
    private String versionNumber = "";
    private String versionId = "";

    public ModrinthVersionInfo(String projectReference, String versionNumber) {
        this.projectReference = projectReference.trim();
        this.versionNumber = versionNumber.trim();
    }

    public ModrinthVersionInfo(String versionId) {
        this.versionId = versionId.trim();
    }

    @NotNull
    public static List<ModrinthVersionInfo> getModrinthVersionsFromJson(URL jsonUrl) {
        ArrayList<ModrinthVersionInfo> result = new ArrayList<ModrinthVersionInfo>();
        JsonObject object = IOUtils.readJson(jsonUrl).getAsJsonObject();
        JsonArray mods = object.getAsJsonArray("modrinthMods");
        mods.forEach(modElement -> {
            JsonObject obj = modElement.getAsJsonObject();
            JsonElement versionIdElement = obj.get("versionId");
            if (versionIdElement instanceof JsonNull) {
                result.add(new ModrinthVersionInfo(obj.get("projectReference").getAsString(), obj.get("versionNumber").getAsString()));
            } else {
                result.add(new ModrinthVersionInfo(versionIdElement.getAsString()));
            }
        });
        return result;
    }

    @NotNull
    public static List<ModrinthVersionInfo> getModrinthVersionsFromJson(String jsonUrl) {
        try {
            return ModrinthVersionInfo.getModrinthVersionsFromJson(new URL(jsonUrl));
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    public String getProjectReference() {
        return this.projectReference;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getVersionId() {
        return this.versionId;
    }
}

