/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Mod {
    private final String name;
    private final String sha1;
    private final long size;
    private final String downloadURL;

    public Mod(String name, String downloadURL, String sha1, long size) {
        this.name = name;
        this.downloadURL = downloadURL;
        this.sha1 = sha1;
        this.size = size;
    }

    @NotNull
    public static List<Mod> getModsFromJson(URL jsonUrl) {
        ArrayList<Mod> result = new ArrayList<Mod>();
        JsonObject object = IOUtils.readJson(jsonUrl).getAsJsonObject();
        JsonArray mods = object.getAsJsonArray("mods");
        mods.forEach(modElement -> result.add(Mod.fromJson(modElement)));
        return result;
    }

    public static Mod fromJson(JsonElement modElement) {
        JsonObject obj = modElement.getAsJsonObject();
        return new Mod(obj.get("name").getAsString(), obj.get("downloadURL").getAsString(), obj.get("sha1").getAsString(), obj.get("size").getAsLong());
    }

    @NotNull
    public static List<Mod> getModsFromJson(String jsonUrl) {
        try {
            return Mod.getModsFromJson(new URL(jsonUrl));
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSha1() {
        return this.sha1;
    }

    public long getSize() {
        return this.size;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }
}

