/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download.json;

import com.google.gson.JsonObject;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class MCP {
    private final String clientURL;
    private final String clientSha1;
    private final long clientSize;

    public MCP(String clientURL, String clientSha1, long clientSize) {
        this.clientURL = clientURL;
        this.clientSha1 = clientSha1;
        this.clientSize = clientSize;
    }

    @NotNull
    public static MCP getMCPFromJson(URL jsonUrl) {
        JsonObject object = IOUtils.readJson(jsonUrl).getAsJsonObject();
        return new MCP(object.get("clientURL").getAsString(), object.get("clientSha1").getAsString(), object.get("clientSize").getAsLong());
    }

    @NotNull
    public static MCP getMCPFromJson(String jsonUrl) {
        try {
            return MCP.getMCPFromJson(new URL(jsonUrl));
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    public String getClientURL() {
        return this.clientURL;
    }

    public String getClientSha1() {
        return this.clientSha1;
    }

    public long getClientSize() {
        return this.clientSize;
    }
}

