/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalFile {
    private final String path;
    private final String downloadURL;
    private final String sha1;
    private final long size;
    private final boolean update;

    public ExternalFile(String path, String downloadURL, String sha1, long size) {
        this.path = path;
        this.downloadURL = downloadURL;
        this.sha1 = sha1;
        this.size = size;
        this.update = true;
    }

    public ExternalFile(String path, String downloadURL, String sha1, long size, boolean update) {
        this.path = path;
        this.downloadURL = downloadURL;
        this.sha1 = sha1;
        this.size = size;
        this.update = update;
    }

    @NotNull
    public static List<ExternalFile> getExternalFilesFromJson(URL jsonUrl) {
        ArrayList<ExternalFile> result = new ArrayList<ExternalFile>();
        JsonArray extfiles = IOUtils.readJson(jsonUrl).getAsJsonObject().getAsJsonArray("extfiles");
        extfiles.forEach(extFileElement -> {
            JsonObject obj = extFileElement.getAsJsonObject();
            String path = obj.get("path").getAsString();
            String sha1 = obj.get("sha1").getAsString();
            String downloadURL = obj.get("downloadURL").getAsString();
            long size = obj.get("size").getAsLong();
            if (obj.get("update") != null) {
                result.add(new ExternalFile(path, downloadURL, sha1, size, obj.get("update").getAsBoolean()));
            } else {
                result.add(new ExternalFile(path, downloadURL, sha1, size));
            }
        });
        return result;
    }

    @NotNull
    public static List<ExternalFile> getExternalFilesFromJson(String jsonUrl) {
        try {
            return ExternalFile.getExternalFilesFromJson(new URL(jsonUrl));
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public String getSha1() {
        return this.sha1;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isUpdate() {
        return this.update;
    }
}

