/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.flowarg.flowcompat.Platform;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.json.AssetDownloadable;
import fr.flowarg.flowupdater.download.json.AssetIndex;
import fr.flowarg.flowupdater.download.json.Downloadable;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowupdater.versions.VanillaVersion;
import java.net.URL;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class VanillaReader {
    private final VanillaVersion version;
    private final IProgressCallback callback;
    private final DownloadList downloadList;

    public VanillaReader(@NotNull FlowUpdater flowUpdater) {
        this.version = flowUpdater.getVanillaVersion();
        this.callback = flowUpdater.getCallback();
        this.downloadList = flowUpdater.getDownloadList();
    }

    public void read() throws Exception {
        this.callback.step(Step.READ);
        this.parseLibraries();
        this.parseAssetIndex();
        this.parseClient();
        this.parseNatives();
        this.parseAssets();
    }

    private void parseLibraries() {
        this.version.getMinecraftLibrariesJson().forEach(jsonElement -> {
            JsonObject artifact;
            JsonObject element = jsonElement.getAsJsonObject();
            if (element == null || !this.checkRules(element)) {
                return;
            }
            JsonObject downloads = element.getAsJsonObject("downloads");
            if (downloads == null) {
                return;
            }
            String name = element.getAsJsonPrimitive("name").getAsString();
            if (name.contains("lwjgl") && name.contains("natives") && name.contains("macos")) {
                boolean platformCheck;
                boolean bl = platformCheck = Platform.isOnMac() && Platform.getArch().equals("64") && System.getProperty("os.arch").equals("aarch64");
                if (platformCheck != name.contains("arm64")) {
                    return;
                }
            }
            if ((artifact = downloads.getAsJsonObject("artifact")) == null) {
                return;
            }
            String url = artifact.getAsJsonPrimitive("url").getAsString();
            int size = artifact.getAsJsonPrimitive("size").getAsInt();
            String path = "libraries/" + artifact.getAsJsonPrimitive("path").getAsString();
            String sha1 = artifact.getAsJsonPrimitive("sha1").getAsString();
            Downloadable downloadable = new Downloadable(url, size, sha1, path);
            if (!this.downloadList.getDownloadableFiles().contains(downloadable)) {
                this.downloadList.getDownloadableFiles().add(downloadable);
            }
        });
        this.downloadList.getDownloadableFiles().addAll(this.version.getAnotherLibraries());
    }

    private void parseAssetIndex() {
        if (this.version.getCustomAssetIndex() != null) {
            return;
        }
        JsonObject assetIndex = this.version.getMinecraftAssetIndex();
        String url = assetIndex.getAsJsonPrimitive("url").getAsString();
        int size = assetIndex.getAsJsonPrimitive("size").getAsInt();
        String name = "assets/indexes/" + url.substring(url.lastIndexOf(47) + 1);
        String sha1 = assetIndex.getAsJsonPrimitive("sha1").getAsString();
        this.downloadList.getDownloadableFiles().add(new Downloadable(url, size, sha1, name));
    }

    private void parseClient() {
        JsonObject client = this.version.getMinecraftClient();
        String clientURL = client.getAsJsonPrimitive("url").getAsString();
        int clientSize = client.getAsJsonPrimitive("size").getAsInt();
        String clientName = clientURL.substring(clientURL.lastIndexOf(47) + 1);
        String clientSha1 = client.getAsJsonPrimitive("sha1").getAsString();
        this.downloadList.getDownloadableFiles().add(new Downloadable(clientURL, clientSize, clientSha1, clientName));
    }

    private void parseNatives() {
        this.version.getMinecraftLibrariesJson().forEach(jsonElement -> {
            JsonObject obj = jsonElement.getAsJsonObject().getAsJsonObject("downloads").getAsJsonObject("classifiers");
            if (obj == null) {
                return;
            }
            JsonObject macObj = obj.getAsJsonObject("natives-macos");
            JsonObject osxObj = obj.getAsJsonObject("natives-osx");
            JsonObject windowsObj = obj.getAsJsonObject(String.format("natives-windows-%s", Platform.getArch()));
            if (windowsObj == null) {
                windowsObj = obj.getAsJsonObject("natives-windows");
            }
            JsonObject linuxObj = obj.getAsJsonObject("natives-linux");
            if (macObj != null && Platform.isOnMac()) {
                this.getNativeForOS("mac", macObj);
            } else if (osxObj != null && Platform.isOnMac()) {
                this.getNativeForOS("mac", osxObj);
            } else if (windowsObj != null && Platform.isOnWindows()) {
                this.getNativeForOS("win", windowsObj);
            } else if (linuxObj != null && Platform.isOnLinux()) {
                this.getNativeForOS("linux", linuxObj);
            }
        });
    }

    private void getNativeForOS(@NotNull String os, @NotNull JsonObject obj) {
        String url = obj.getAsJsonPrimitive("url").getAsString();
        int size = obj.getAsJsonPrimitive("size").getAsInt();
        String path = obj.getAsJsonPrimitive("path").getAsString();
        String name = "natives/" + path.substring(path.lastIndexOf(47) + 1);
        String sha1 = obj.getAsJsonPrimitive("sha1").getAsString();
        if (!os.equals("mac")) {
            if (name.contains("-3.2.1-") && name.contains("lwjgl")) {
                return;
            }
            if (name.contains("-2.9.2-") && name.contains("lwjgl")) {
                return;
            }
        } else if (name.contains("-3.2.2-") && name.contains("lwjgl")) {
            return;
        }
        this.downloadList.getDownloadableFiles().add(new Downloadable(url, size, sha1, name));
    }

    private void parseAssets() throws Exception {
        HashSet<AssetDownloadable> toDownload = new HashSet<AssetDownloadable>(this.version.getAnotherAssets());
        AssetIndex assetIndex = this.version.getCustomAssetIndex() == null ? (AssetIndex)new GsonBuilder().disableHtmlEscaping().create().fromJson(IOUtils.getContent(new URL(this.version.getMinecraftAssetIndex().get("url").getAsString())), AssetIndex.class) : this.version.getCustomAssetIndex();
        assetIndex.getUniqueObjects().values().forEach(assetDownloadable -> toDownload.add(new AssetDownloadable(assetDownloadable.getHash(), assetDownloadable.getSize())));
        this.downloadList.getDownloadableAssets().addAll(toDownload);
    }

    private boolean checkRules(@NotNull JsonObject obj) {
        JsonElement rulesElement = obj.get("rules");
        if (rulesElement == null) {
            return true;
        }
        AtomicBoolean canDownload = new AtomicBoolean(true);
        rulesElement.getAsJsonArray().forEach(jsonElement -> {
            JsonObject object = jsonElement.getAsJsonObject();
            String actionValue = object.getAsJsonPrimitive("action").getAsString();
            JsonObject osObject = object.getAsJsonObject("os");
            if (actionValue.equals("allow")) {
                if (osObject == null) {
                    return;
                }
                String os = osObject.getAsJsonPrimitive("name").getAsString();
                canDownload.set(this.check(os));
            } else if (actionValue.equals("disallow")) {
                String os = osObject.getAsJsonPrimitive("name").getAsString();
                canDownload.set(!this.check(os));
            }
        });
        return canDownload.get();
    }

    private boolean check(@NotNull String os) {
        return os.equalsIgnoreCase("osx") && Platform.isOnMac() || os.equalsIgnoreCase("macos") && Platform.isOnMac() || os.equalsIgnoreCase("windows") && Platform.isOnWindows() || os.equalsIgnoreCase("linux") && Platform.isOnLinux();
    }
}

