/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowstringer.StringUtils;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.json.Downloadable;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowzipper.ZipUtils;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;

public class VanillaDownloader {
    private final Path dir;
    private final ILogger logger;
    private final IProgressCallback callback;
    private final DownloadList downloadList;
    private final Path natives;
    private final Path assets;
    private final String vanillaJsonURL;

    public VanillaDownloader(Path dir, @NotNull FlowUpdater flowUpdater) throws Exception {
        this.dir = dir;
        this.logger = flowUpdater.getLogger();
        this.callback = flowUpdater.getCallback();
        this.downloadList = flowUpdater.getDownloadList();
        this.natives = this.dir.resolve("natives");
        this.assets = this.dir.resolve("assets");
        this.vanillaJsonURL = flowUpdater.getVanillaVersion().getJsonURL();
        Files.createDirectories(this.dir.resolve("libraries"), new FileAttribute[0]);
        Files.createDirectories(this.assets, new FileAttribute[0]);
        Files.createDirectories(this.natives, new FileAttribute[0]);
        this.downloadList.init();
    }

    public void download() throws Exception {
        this.downloadLibraries();
        this.downloadAssets();
        this.extractNatives();
        this.logger.info("All vanilla files were successfully downloaded!");
    }

    private void downloadLibraries() throws Exception {
        this.logger.info("Checking library files...");
        this.callback.step(Step.DL_LIBS);
        if (this.vanillaJsonURL != null) {
            this.downloadVanillaJson();
        }
        for (Downloadable downloadable : this.downloadList.getDownloadableFiles()) {
            Path filePath = this.dir.resolve(downloadable.getName());
            if (Files.notExists(filePath, new LinkOption[0]) || !FileUtils.getSHA1((Path)filePath).equalsIgnoreCase(downloadable.getSha1()) || Files.size(filePath) != downloadable.getSize()) {
                IOUtils.download(this.logger, new URL(downloadable.getUrl()), filePath);
                this.callback.onFileDownloaded(filePath);
            }
            this.downloadList.incrementDownloaded(downloadable.getSize());
            this.callback.update(this.downloadList.getDownloadInfo());
        }
    }

    private void downloadVanillaJson() throws Exception {
        Path vanillaJsonTarget = this.dir.resolve(this.vanillaJsonURL.substring(this.vanillaJsonURL.lastIndexOf(47) + 1));
        String vanillaJsonResourceName = this.vanillaJsonURL.substring(this.vanillaJsonURL.lastIndexOf(47));
        String vanillaJsonPathUrl = StringUtils.empty((String)StringUtils.empty((String)this.vanillaJsonURL, (String)"https://launchermeta.mojang.com/v1/packages/"), (String)"https://piston-meta.mojang.com/v1/packages/");
        if (Files.notExists(vanillaJsonTarget, new LinkOption[0]) || !FileUtils.getSHA1((Path)vanillaJsonTarget).equals(StringUtils.empty((String)vanillaJsonPathUrl, (String)vanillaJsonResourceName))) {
            IOUtils.download(this.logger, new URL(this.vanillaJsonURL), vanillaJsonTarget);
        }
    }

    private void extractNatives() throws Exception {
        Stream<Path> natives;
        boolean flag = false;
        List existingNatives = FileUtils.list((Path)this.natives);
        if (!existingNatives.isEmpty()) {
            for (Path minecraftNative : FileUtils.list((Path)this.natives).stream().filter(path -> path.getFileName().toString().endsWith(".jar")).collect(Collectors.toList())) {
                JarFile jarFile = new JarFile(minecraftNative.toFile());
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    Path flPath;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || entry.getName().endsWith(".git") || entry.getName().endsWith(".sha1") || entry.getName().contains("META-INF") || Files.exists(flPath = this.natives.resolve(entry.getName()), new LinkOption[0]) && entry.getCrc() == FileUtils.getCRC32((Path)flPath)) continue;
                    flag = true;
                    break;
                }
                jarFile.close();
                if (!flag) continue;
                break;
            }
        }
        if (flag) {
            this.logger.info("Extracting natives...");
            this.callback.step(Step.EXTRACT_NATIVES);
            natives = FileUtils.list((Path)this.natives).stream();
            natives.filter(file -> !Files.isDirectory(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".jar")).forEach(file -> {
                try {
                    ZipUtils.unzipJar((Path)this.natives, (Path)file, (String[])new String[]{"ignoreMetaInf"});
                }
                catch (Exception e) {
                    this.logger.printStackTrace((Throwable)e);
                }
            });
            natives.close();
        }
        natives = Files.list(this.natives);
        Throwable throwable = null;
        try {
            natives.forEach(path -> {
                try {
                    if (path.getFileName().toString().endsWith(".git") || path.getFileName().toString().endsWith(".sha1")) {
                        Files.delete(path);
                    } else if (Files.isDirectory(path, new LinkOption[0])) {
                        FileUtils.deleteDirectory((Path)path);
                    }
                }
                catch (Exception e) {
                    this.logger.printStackTrace((Throwable)e);
                }
            });
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (natives != null) {
                if (throwable != null) {
                    try {
                        natives.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    natives.close();
                }
            }
        }
    }

    private void downloadAssets() {
        this.logger.info("Checking assets...");
        this.callback.step(Step.DL_ASSETS);
        IOUtils.executeAsyncForEach(this.downloadList.getDownloadableAssets(), Executors.newWorkStealingPool(), assetDownloadable -> {
            try {
                Path downloadPath = this.assets.resolve(assetDownloadable.getFile());
                if (Files.notExists(downloadPath, new LinkOption[0]) || Files.size(downloadPath) != assetDownloadable.getSize()) {
                    Path localAssetPath = IOUtils.getMinecraftFolder().resolve("assets").resolve(assetDownloadable.getFile());
                    if (Files.exists(localAssetPath, new LinkOption[0]) && Files.size(localAssetPath) == assetDownloadable.getSize()) {
                        IOUtils.copy(this.logger, localAssetPath, downloadPath);
                    } else {
                        IOUtils.download(this.logger, new URL(assetDownloadable.getUrl()), downloadPath);
                        this.callback.onFileDownloaded(downloadPath);
                    }
                }
                this.downloadList.incrementDownloaded(assetDownloadable.getSize());
                this.callback.update(this.downloadList.getDownloadInfo());
            }
            catch (Exception e) {
                this.logger.printStackTrace((Throwable)e);
            }
        });
    }
}

