/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download;

import fr.flowarg.flowupdater.download.json.AssetDownloadable;
import fr.flowarg.flowupdater.download.json.Downloadable;
import fr.flowarg.flowupdater.download.json.ExternalFile;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.integrations.optifineintegration.OptiFine;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DownloadList {
    private final List<Downloadable> downloadableFiles = new ArrayList<Downloadable>();
    private final List<AssetDownloadable> downloadableAssets = new ArrayList<AssetDownloadable>();
    private final List<ExternalFile> extFiles = new ArrayList<ExternalFile>();
    private final List<Mod> mods = new ArrayList<Mod>();
    private final Lock updateInfoLock = new ReentrantLock();
    private OptiFine optiFine = null;
    private DownloadInfo downloadInfo;
    private boolean init = false;

    public void init() {
        if (this.init) {
            return;
        }
        this.downloadInfo = new DownloadInfo();
        this.downloadableFiles.forEach(downloadable -> this.downloadInfo.totalToDownloadBytes.set(this.downloadInfo.totalToDownloadBytes.get() + downloadable.getSize()));
        this.downloadableAssets.forEach(downloadable -> this.downloadInfo.totalToDownloadBytes.set(this.downloadInfo.totalToDownloadBytes.get() + downloadable.getSize()));
        this.extFiles.forEach(externalFile -> this.downloadInfo.totalToDownloadBytes.set(this.downloadInfo.totalToDownloadBytes.get() + externalFile.getSize()));
        this.mods.forEach(mod -> this.downloadInfo.totalToDownloadBytes.set(this.downloadInfo.totalToDownloadBytes.get() + mod.getSize()));
        this.downloadInfo.totalToDownloadFiles.set(this.downloadInfo.totalToDownloadFiles.get() + this.downloadableFiles.size() + this.downloadableAssets.size() + this.extFiles.size() + this.mods.size());
        if (this.optiFine != null) {
            this.downloadInfo.totalToDownloadBytes.set(this.downloadInfo.totalToDownloadBytes.get() + this.optiFine.getSize());
            this.downloadInfo.totalToDownloadFiles.incrementAndGet();
        }
        this.init = true;
    }

    public void incrementDownloaded(long bytes) {
        this.updateInfoLock.lock();
        this.downloadInfo.downloadedFiles.incrementAndGet();
        this.downloadInfo.downloadedBytes.set(this.downloadInfo.downloadedBytes.get() + bytes);
        this.updateInfoLock.unlock();
    }

    public DownloadInfo getDownloadInfo() {
        return this.downloadInfo;
    }

    public List<AssetDownloadable> getDownloadableAssets() {
        return this.downloadableAssets;
    }

    public List<Downloadable> getDownloadableFiles() {
        return this.downloadableFiles;
    }

    public List<ExternalFile> getExtFiles() {
        return this.extFiles;
    }

    public List<Mod> getMods() {
        return this.mods;
    }

    public OptiFine getOptiFine() {
        return this.optiFine;
    }

    public void setOptiFine(OptiFine optiFine) {
        this.optiFine = optiFine;
    }

    public void clear() {
        this.downloadableFiles.clear();
        this.extFiles.clear();
        this.downloadableAssets.clear();
        this.mods.clear();
        this.optiFine = null;
        this.downloadInfo.reset();
        this.init = false;
    }

    public static class DownloadInfo {
        private final AtomicLong totalToDownloadBytes = new AtomicLong(0L);
        private final AtomicLong downloadedBytes = new AtomicLong(0L);
        private final AtomicInteger totalToDownloadFiles = new AtomicInteger(0);
        private final AtomicInteger downloadedFiles = new AtomicInteger(0);

        public void reset() {
            this.totalToDownloadBytes.set(0L);
            this.downloadedBytes.set(0L);
            this.totalToDownloadFiles.set(0);
            this.downloadedFiles.set(0);
        }

        public long getTotalToDownloadBytes() {
            return this.totalToDownloadBytes.get();
        }

        public long getDownloadedBytes() {
            return this.downloadedBytes.get();
        }

        public int getTotalToDownloadFiles() {
            return this.totalToDownloadFiles.get();
        }

        public int getDownloadedFiles() {
            return this.downloadedFiles.get();
        }
    }
}

