/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowlogger.Logger;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.VanillaDownloader;
import fr.flowarg.flowupdater.download.VanillaReader;
import fr.flowarg.flowupdater.download.json.ExternalFile;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.integrations.IntegrationManager;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.ICurseForgeCompatible;
import fr.flowarg.flowupdater.integrations.modrinthintegration.IModrinthCompatible;
import fr.flowarg.flowupdater.integrations.optifineintegration.IOptiFineCompatible;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowupdater.utils.UpdaterOptions;
import fr.flowarg.flowupdater.utils.VersionChecker;
import fr.flowarg.flowupdater.utils.builderapi.BuilderArgument;
import fr.flowarg.flowupdater.utils.builderapi.BuilderException;
import fr.flowarg.flowupdater.utils.builderapi.IBuilder;
import fr.flowarg.flowupdater.versions.IModLoaderVersion;
import fr.flowarg.flowupdater.versions.VanillaVersion;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlowUpdater {
    public static final String FU_VERSION = "1.9.1";
    private final VanillaVersion vanillaVersion;
    private final ILogger logger;
    private final IModLoaderVersion modLoaderVersion;
    private final IProgressCallback callback;
    private final DownloadList downloadList;
    private final UpdaterOptions updaterOptions;
    private final List<ExternalFile> externalFiles;
    private final List<Runnable> postExecutions;
    private final IntegrationManager integrationManager;
    public static final IProgressCallback NULL_CALLBACK = new IProgressCallback(){

        @Override
        public void init(@NotNull ILogger logger) {
            logger.info("Default callback will be used.");
        }
    };
    public static final ILogger DEFAULT_LOGGER = new Logger("[FlowUpdater]", null);

    private FlowUpdater(VanillaVersion vanillaVersion, ILogger logger, UpdaterOptions updaterOptions, IProgressCallback callback, List<ExternalFile> externalFiles, List<Runnable> postExecutions, IModLoaderVersion modLoaderVersion) {
        this.logger = logger;
        this.vanillaVersion = vanillaVersion;
        this.externalFiles = externalFiles;
        this.postExecutions = postExecutions;
        this.modLoaderVersion = modLoaderVersion;
        this.updaterOptions = updaterOptions;
        this.callback = callback;
        this.downloadList = new DownloadList();
        this.integrationManager = new IntegrationManager(this);
        this.logger.info(String.format("------------------------- FlowUpdater for Minecraft %s v%s -------------------------", this.vanillaVersion.getName(), FU_VERSION));
        if (this.updaterOptions.isVersionChecker()) {
            VersionChecker.run(this.logger);
        }
        this.callback.init(this.logger);
    }

    public void update(Path dir) throws Exception {
        this.checkExtFiles(dir);
        this.updateMinecraft(dir);
        this.updateExtFiles(dir);
        this.runPostExecutions();
        this.endUpdate();
    }

    private void checkExtFiles(Path dir) throws Exception {
        this.updaterOptions.getExternalFileDeleter().delete(this.externalFiles, this.downloadList, dir);
    }

    private void updateMinecraft(@NotNull Path dir) throws Exception {
        this.loadVanillaStuff();
        if (this.modLoaderVersion != null) {
            this.loadModLoader(dir);
        }
        this.startVanillaDownload(dir);
        if (this.modLoaderVersion != null) {
            this.installModLoader(dir);
        }
    }

    private void loadVanillaStuff() throws Exception {
        if (this.vanillaVersion == VanillaVersion.NULL_VERSION) {
            this.downloadList.init();
            return;
        }
        this.logger.info(String.format("Reading data about %s Minecraft version...", this.vanillaVersion.getName()));
        new VanillaReader(this).read();
    }

    private void loadModLoader(@NotNull Path dir) throws Exception {
        Path modsDirPath = dir.resolve("mods");
        this.checkMods(this.modLoaderVersion, modsDirPath);
        if (this.modLoaderVersion instanceof ICurseForgeCompatible) {
            this.integrationManager.loadCurseForgeIntegration(modsDirPath, (ICurseForgeCompatible)((Object)this.modLoaderVersion));
        }
        if (this.modLoaderVersion instanceof IModrinthCompatible) {
            this.integrationManager.loadModrinthIntegration(modsDirPath, (IModrinthCompatible)((Object)this.modLoaderVersion));
        }
        if (this.modLoaderVersion instanceof IOptiFineCompatible) {
            this.integrationManager.loadOptiFineIntegration(modsDirPath, (IOptiFineCompatible)((Object)this.modLoaderVersion));
        }
    }

    private void checkMods(@NotNull IModLoaderVersion modLoader, Path modsDir) throws Exception {
        for (Mod mod : modLoader.getMods()) {
            Path filePath = modsDir.resolve(mod.getName());
            if (!Files.notExists(filePath, new LinkOption[0]) && Files.size(filePath) == mod.getSize() && (mod.getSha1().isEmpty() || FileUtils.getSHA1((Path)filePath).equalsIgnoreCase(mod.getSha1()))) continue;
            this.downloadList.getMods().add(mod);
        }
    }

    private void startVanillaDownload(Path dir) throws Exception {
        if (Files.notExists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        new VanillaDownloader(dir, this).download();
    }

    private void installModLoader(Path dir) throws Exception {
        if (this.modLoaderVersion == null) {
            return;
        }
        this.modLoaderVersion.attachFlowUpdater(this);
        if (!this.modLoaderVersion.isModLoaderAlreadyInstalled(dir)) {
            this.modLoaderVersion.install(dir);
            this.logger.info(this.modLoaderVersion.name() + ", version: " + this.modLoaderVersion.getModLoaderVersion() + " has been successfully installed!");
        } else {
            this.logger.info(this.modLoaderVersion.name() + " is already installed! Skipping installation...");
        }
        this.modLoaderVersion.installMods(dir.resolve("mods"));
    }

    private void updateExtFiles(Path dir) {
        if (this.downloadList.getExtFiles().isEmpty()) {
            return;
        }
        this.callback.step(Step.EXTERNAL_FILES);
        this.logger.info("Downloading external file(s)...");
        this.downloadList.getExtFiles().forEach(extFile -> {
            try {
                Path filePath = dir.resolve(extFile.getPath());
                IOUtils.download(this.logger, new URL(extFile.getDownloadURL()), filePath);
                this.callback.onFileDownloaded(filePath);
            }
            catch (Exception e) {
                this.logger.printStackTrace((Throwable)e);
            }
            this.downloadList.incrementDownloaded(extFile.getSize());
            this.callback.update(this.downloadList.getDownloadInfo());
        });
    }

    private void runPostExecutions() {
        if (this.postExecutions.isEmpty()) {
            return;
        }
        this.callback.step(Step.POST_EXECUTIONS);
        this.logger.info("Running post executions...");
        this.postExecutions.forEach(Runnable::run);
    }

    private void endUpdate() {
        this.callback.step(Step.END);
        this.callback.update(this.downloadList.getDownloadInfo());
        this.downloadList.clear();
    }

    public VanillaVersion getVanillaVersion() {
        return this.vanillaVersion;
    }

    public IModLoaderVersion getModLoaderVersion() {
        return this.modLoaderVersion;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public IProgressCallback getCallback() {
        return this.callback;
    }

    public List<ExternalFile> getExternalFiles() {
        return this.externalFiles;
    }

    public List<Runnable> getPostExecutions() {
        return this.postExecutions;
    }

    public DownloadList getDownloadList() {
        return this.downloadList;
    }

    public UpdaterOptions getUpdaterOptions() {
        return this.updaterOptions;
    }

    public static class FlowUpdaterBuilder
    implements IBuilder<FlowUpdater> {
        private final BuilderArgument<VanillaVersion> versionArgument = new BuilderArgument<VanillaVersion>("VanillaVersion", () -> VanillaVersion.NULL_VERSION).optional();
        private final BuilderArgument<ILogger> loggerArgument = new BuilderArgument<ILogger>("Logger", () -> DEFAULT_LOGGER).optional();
        private final BuilderArgument<UpdaterOptions> updaterOptionsArgument = new BuilderArgument<UpdaterOptions>("UpdaterOptions", () -> UpdaterOptions.DEFAULT).optional();
        private final BuilderArgument<IProgressCallback> progressCallbackArgument = new BuilderArgument<IProgressCallback>("Callback", () -> NULL_CALLBACK).optional();
        private final BuilderArgument<List<ExternalFile>> externalFilesArgument = new BuilderArgument<List>("External Files", ArrayList::new).optional();
        private final BuilderArgument<List<Runnable>> postExecutionsArgument = new BuilderArgument<List>("Post Executions", ArrayList::new).optional();
        private final BuilderArgument<IModLoaderVersion> modLoaderVersionArgument = new BuilderArgument("ModLoader").optional().require(this.versionArgument);

        public FlowUpdaterBuilder withVanillaVersion(VanillaVersion version) {
            this.versionArgument.set(version);
            return this;
        }

        public FlowUpdaterBuilder withLogger(ILogger logger) {
            this.loggerArgument.set(logger);
            return this;
        }

        public FlowUpdaterBuilder withUpdaterOptions(UpdaterOptions updaterOptions) {
            this.updaterOptionsArgument.set(updaterOptions);
            return this;
        }

        public FlowUpdaterBuilder withProgressCallback(IProgressCallback callback) {
            this.progressCallbackArgument.set(callback);
            return this;
        }

        public FlowUpdaterBuilder withExternalFiles(Collection<ExternalFile> externalFiles) {
            this.externalFilesArgument.get().addAll(externalFiles);
            return this;
        }

        public FlowUpdaterBuilder withExternalFiles(ExternalFile ... externalFiles) {
            return this.withExternalFiles(Arrays.asList(externalFiles));
        }

        public FlowUpdaterBuilder withExternalFiles(URL externalFilesJsonUrl) {
            return this.withExternalFiles(ExternalFile.getExternalFilesFromJson(externalFilesJsonUrl));
        }

        public FlowUpdaterBuilder withExternalFiles(String externalFilesJsonUrl) {
            return this.withExternalFiles(ExternalFile.getExternalFilesFromJson(externalFilesJsonUrl));
        }

        public FlowUpdaterBuilder withPostExecutions(Collection<Runnable> postExecutions) {
            this.postExecutionsArgument.get().addAll(postExecutions);
            return this;
        }

        public FlowUpdaterBuilder withPostExecutions(Runnable ... postExecutions) {
            return this.withPostExecutions(Arrays.asList(postExecutions));
        }

        public FlowUpdaterBuilder withModLoaderVersion(IModLoaderVersion modLoaderVersion) {
            this.modLoaderVersionArgument.set(modLoaderVersion);
            return this;
        }

        @Override
        public FlowUpdater build() throws BuilderException {
            return new FlowUpdater(this.versionArgument.get(), this.loggerArgument.get(), this.updaterOptionsArgument.get(), this.progressCallbackArgument.get(), this.externalFilesArgument.get(), this.postExecutionsArgument.get(), this.modLoaderVersionArgument.get());
        }
    }
}

