/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.curseforgeplugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.util.OkHttpUtils;
import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowstringer.StringUtils;
import fr.flowarg.flowupdater.curseforgeplugin.CurseMod;
import fr.flowarg.flowupdater.curseforgeplugin.CurseModPack;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class CurseForgePlugin {
    public static final CurseForgePlugin INSTANCE = new CurseForgePlugin();
    private ILogger logger;
    private Path folder;

    public URL getURLOfFile(int projectID, int fileID) {
        try {
            return CurseAPI.fileDownloadURL((int)projectID, (int)fileID).map(HttpUrl::url).orElse(null);
        }
        catch (CurseException e) {
            this.getLogger().printStackTrace((Throwable)e);
            return null;
        }
    }

    public CurseMod getCurseMod(ProjectMod mod) {
        return this.getCurseMod(mod.getProjectID(), mod.getFileID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurseMod getCurseMod(int projectID, int fileID) {
        URL url = this.getURLOfFile(projectID, fileID);
        HttpsURLConnection connection = null;
        try {
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setInstanceFollowRedirects(true);
            connection.setUseCaches(false);
            String md5 = connection.getHeaderField("ETag").replace("\"", "");
            int length = Integer.parseInt(connection.getHeaderField("Content-Length"));
            CurseMod curseMod = new CurseMod(url.getFile().substring(url.getFile().lastIndexOf(47) + 1), url.toExternalForm(), md5, length);
            return curseMod;
        }
        catch (Exception e) {
            this.getLogger().printStackTrace((Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return CurseMod.BAD;
    }

    public CurseModPack getCurseModPack(int projectID, int fileID, boolean installExtFiles) {
        try {
            this.extractModPack(this.checkForUpdates(projectID, fileID), installExtFiles);
            return this.parseMods(installExtFiles);
        }
        catch (Exception e) {
            this.getLogger().printStackTrace((Throwable)e);
            return CurseModPack.BAD;
        }
    }

    private Path checkForUpdates(int projectID, int fileID) throws Exception {
        URL link = this.getURLOfFile(projectID, fileID);
        String linkStr = link.toExternalForm();
        Path outPath = Paths.get(this.getFolder().toString(), linkStr.substring(linkStr.lastIndexOf(47) + 1));
        if (Files.notExists(outPath, new LinkOption[0]) || !FileUtils.getMD5((Path)outPath).equalsIgnoreCase(this.getMD5(link))) {
            this.getLogger().info(String.format("Downloading %s from %s...", outPath.getFileName().toString(), linkStr));
            Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
            Files.copy(this.catchForbidden(link), outPath, StandardCopyOption.REPLACE_EXISTING);
        }
        return outPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMD5(URL link) {
        HttpsURLConnection connection = null;
        try {
            connection = (HttpsURLConnection)link.openConnection();
            connection.setRequestMethod("GET");
            connection.setInstanceFollowRedirects(true);
            connection.setUseCaches(false);
            String string = connection.getHeaderField("ETag").replace("\"", "");
            return string;
        }
        catch (Exception e) {
            this.getLogger().printStackTrace((Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return "";
    }

    private void extractModPack(Path out, boolean installExtFiles) throws Exception {
        this.getLogger().info("Extracting mod pack...");
        ZipFile zipFile = new ZipFile(out.toFile(), 1, StandardCharsets.UTF_8);
        Path dirPath = this.getFolder().getParent();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            NioZipObject nioZipObject;
            ZipEntry entry = entries.nextElement();
            Path flPath = Paths.get(dirPath.toString(), StringUtils.empty((String)entry.getName(), (String)"overrides/"));
            if (entry.getName().equalsIgnoreCase("manifest.json") && Files.exists(flPath, new LinkOption[0]) && entry.getCrc() == FileUtils.getCRC32((Path)flPath)) break;
            if (installExtFiles && !entry.getName().equals("modlist.html")) {
                if (!Files.notExists(flPath, new LinkOption[0])) continue;
                if (flPath.getFileName().toString().endsWith(flPath.getFileSystem().getSeparator())) {
                    Files.createDirectories(flPath, new FileAttribute[0]);
                }
                if (entry.isDirectory()) continue;
                nioZipObject = new NioZipObject(flPath, zipFile.getInputStream(entry));
                nioZipObject.transfer();
                nioZipObject.close();
                continue;
            }
            if (!entry.getName().equals("manifest.json")) continue;
            nioZipObject = new NioZipObject(flPath, zipFile.getInputStream(entry));
            nioZipObject.transfer();
            nioZipObject.close();
        }
        zipFile.close();
    }

    private CurseModPack parseMods(boolean installExtFiles) throws Exception {
        this.getLogger().info("Fetching mods...");
        Path dirPath = Paths.get(this.getFolder().getParent().toString(), new String[0]);
        BufferedReader manifestReader = Files.newBufferedReader(Paths.get(dirPath.toString(), "manifest.json"));
        JsonObject manifestObj = JsonParser.parseReader((Reader)manifestReader).getAsJsonObject();
        ArrayList manifestFiles = new ArrayList();
        manifestObj.getAsJsonArray("files").forEach(jsonElement -> manifestFiles.add(ProjectMod.fromJsonObject(jsonElement.getAsJsonObject())));
        Path cachePath = Paths.get(dirPath.toString(), "manifest.cache.json");
        if (Files.notExists(cachePath, new LinkOption[0])) {
            Files.write(cachePath, Collections.singletonList("[]"), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        BufferedReader cacheReader = Files.newBufferedReader(cachePath);
        JsonArray cacheArray = JsonParser.parseReader((Reader)cacheReader).getAsJsonArray();
        ArrayList<CurseModPack.CurseModPackMod> mods = new ArrayList<CurseModPack.CurseModPackMod>();
        cacheArray.forEach(jsonElement -> {
            JsonObject object = jsonElement.getAsJsonObject();
            String name = object.get("name").getAsString();
            String downloadURL = object.get("downloadURL").getAsString();
            String md5 = object.get("md5").getAsString();
            int length = object.get("length").getAsInt();
            ProjectMod projectMod = ProjectMod.fromJsonObject(object);
            boolean required = projectMod.isRequired();
            mods.add(new CurseModPack.CurseModPackMod(name, downloadURL, md5, length, required));
            manifestFiles.remove(projectMod);
        });
        manifestFiles.forEach(projectMod -> {
            boolean required = projectMod.isRequired();
            CurseModPack.CurseModPackMod mod = new CurseModPack.CurseModPackMod(this.getCurseMod((ProjectMod)projectMod), required);
            JsonObject inCache = new JsonObject();
            inCache.addProperty("name", mod.getName());
            inCache.addProperty("downloadURL", mod.getDownloadURL());
            inCache.addProperty("md5", mod.getMd5());
            inCache.addProperty("length", (Number)mod.getLength());
            inCache.addProperty("required", Boolean.valueOf(required));
            inCache.addProperty("projectID", (Number)projectMod.getProjectID());
            inCache.addProperty("fileID", (Number)projectMod.getFileID());
            cacheArray.add((JsonElement)inCache);
            mods.add(mod);
        });
        manifestReader.close();
        cacheReader.close();
        Files.write(cachePath, Collections.singletonList(cacheArray.toString()), StandardCharsets.UTF_8, new OpenOption[0]);
        String modPackName = manifestObj.get("name").getAsString();
        String modPackVersion = manifestObj.get("version").getAsString();
        String modPackAuthor = manifestObj.get("author").getAsString();
        return new CurseModPack(modPackName, modPackVersion, modPackAuthor, mods, installExtFiles);
    }

    public void shutdownOKHTTP() {
        OkHttpClient client = OkHttpUtils.getClient();
        if (client != null) {
            client.dispatcher().executorService().shutdown();
            client.connectionPool().evictAll();
            if (client.cache() != null) {
                try {
                    Objects.requireNonNull(client.cache()).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public InputStream catchForbidden(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
        connection.setInstanceFollowRedirects(true);
        return connection.getInputStream();
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public Path getFolder() {
        return this.folder;
    }

    public void setFolder(Path folder) {
        this.folder = folder;
        try {
            Files.createDirectories(this.folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.printStackTrace((Throwable)e);
        }
    }

    private static class ProjectMod {
        private final int projectID;
        private final int fileID;
        private final boolean required;

        public ProjectMod(int projectID, int fileID, boolean required) {
            this.projectID = projectID;
            this.fileID = fileID;
            this.required = required;
        }

        private static ProjectMod fromJsonObject(JsonObject object) {
            return new ProjectMod(object.get("projectID").getAsInt(), object.get("fileID").getAsInt(), object.get("required").getAsBoolean());
        }

        public int getProjectID() {
            return this.projectID;
        }

        public int getFileID() {
            return this.fileID;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectMod that = (ProjectMod)o;
            if (this.projectID != that.projectID) {
                return false;
            }
            if (this.fileID != that.fileID) {
                return false;
            }
            return this.required == that.required;
        }

        public int hashCode() {
            int result = this.projectID;
            result = 31 * result + this.fileID;
            result = 31 * result + (this.required ? 1 : 0);
            return result;
        }
    }

    private static class NioZipObject {
        private final OutputStream pathStream;
        private final BufferedOutputStream fo;
        private final InputStream is;

        public NioZipObject(Path path, InputStream is) throws IOException {
            this.pathStream = Files.newOutputStream(path, new OpenOption[0]);
            this.fo = new BufferedOutputStream(this.pathStream);
            this.is = is;
        }

        public void transfer() throws IOException {
            while (this.is.available() > 0) {
                this.fo.write(this.is.read());
            }
        }

        public void close() throws IOException {
            this.fo.close();
            this.pathStream.close();
            this.is.close();
        }
    }
}

