/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowzipper;

import fr.flowarg.flowio.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public final class ZipUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static void decompressTarArchive(File tarGzFile, File destinationDir) throws IOException {
        try (FileInputStream fis = new FileInputStream(tarGzFile);
             BufferedInputStream bis = new BufferedInputStream(fis);
             GzipCompressorInputStream gzipIn = new GzipCompressorInputStream((InputStream)bis);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);){
            TarArchiveEntry entry;
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                FileOutputStream fos;
                block73: {
                    if (entry.isDirectory()) {
                        File f = new File(destinationDir, entry.getName());
                        f.mkdirs();
                        continue;
                    }
                    byte[] data = new byte[4096];
                    fos = new FileOutputStream(new File(destinationDir, entry.getName()), false);
                    Throwable throwable = null;
                    try {
                        try (BufferedOutputStream dest = new BufferedOutputStream(fos, 4096);){
                            int count;
                            while ((count = tarIn.read(data, 0, 4096)) != -1) {
                                dest.write(data, 0, count);
                            }
                        }
                        if (fos == null) continue;
                        if (throwable == null) break block73;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void decompressTarArchive(Path tarGzFile, Path destinationDir) throws IOException {
        try (InputStream is = Files.newInputStream(tarGzFile, new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(is);
             GzipCompressorInputStream gzipIn = new GzipCompressorInputStream((InputStream)bis);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);){
            TarArchiveEntry entry;
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                OutputStream fos;
                block73: {
                    if (entry.isDirectory()) {
                        Files.createDirectories(Paths.get(destinationDir.toString(), entry.getName()), new FileAttribute[0]);
                        continue;
                    }
                    byte[] data = new byte[4096];
                    fos = Files.newOutputStream(Paths.get(destinationDir.toString(), entry.getName()), new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        try (BufferedOutputStream dest = new BufferedOutputStream(fos, 4096);){
                            int count;
                            while ((count = tarIn.read(data, 0, 4096)) != -1) {
                                dest.write(data, 0, count);
                            }
                        }
                        if (fos == null) continue;
                        if (throwable == null) break block73;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }

    public static void gzipFile(Path baseFile, Path newFile) throws IOException {
        byte[] buffer = new byte[4096];
        if (baseFile != null && newFile != null) {
            int bytesRead;
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(Files.newOutputStream(newFile, new OpenOption[0]));
            BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(baseFile, new OpenOption[0]));
            while ((bytesRead = fileInputStream.read(buffer)) > 0) {
                gzipOutputStream.write(buffer, 0, bytesRead);
            }
            fileInputStream.close();
            gzipOutputStream.finish();
            gzipOutputStream.close();
        }
    }

    @Deprecated
    public static void unzipJarWithLZMACompat(File destinationDir, File jarFile) throws IOException {
        File file;
        String fileName;
        JarEntry entry;
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enums = jar.entries();
        while (enums.hasMoreElements()) {
            entry = enums.nextElement();
            fileName = destinationDir + File.separator + entry.getName();
            file = new File(fileName);
            if (!fileName.endsWith("/")) continue;
            file.mkdirs();
        }
        enums = jar.entries();
        while (enums.hasMoreElements()) {
            entry = enums.nextElement();
            fileName = destinationDir + File.separator + entry.getName();
            file = new File(fileName);
            if (fileName.endsWith("/")) continue;
            if (fileName.endsWith(".lzma")) {
                new File(destinationDir, "data").mkdir();
                InputStream stream = jar.getInputStream(entry);
                Files.copy(stream, new File(destinationDir, entry.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                stream.close();
            } else {
                InputStream is = jar.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(file);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
            }
            jar.getInputStream(entry).close();
        }
        jar.close();
    }

    public static void unzipJarWithLZMACompat(Path destinationDir, Path jarFile) throws IOException {
        JarEntry entry;
        JarFile jar = new JarFile(jarFile.toFile());
        Enumeration<JarEntry> enums = jar.entries();
        while (enums.hasMoreElements()) {
            entry = enums.nextElement();
            Path file = Paths.get(destinationDir.toString(), entry.getName());
            if (!file.getFileName().toString().endsWith("/")) continue;
            Files.createDirectories(file, new FileAttribute[0]);
        }
        enums = jar.entries();
        while (enums.hasMoreElements()) {
            entry = enums.nextElement();
            Path path = Paths.get(destinationDir.toString(), entry.getName());
            String fileName = path.getFileName().toString();
            if (fileName.endsWith("/")) continue;
            if (fileName.endsWith(".lzma")) {
                Files.createDirectory(Paths.get(destinationDir.toString(), "data"), new FileAttribute[0]);
                InputStream stream = jar.getInputStream(entry);
                Files.copy(stream, Paths.get(destinationDir.toString(), entry.getName()), StandardCopyOption.REPLACE_EXISTING);
                stream.close();
            } else {
                InputStream is = jar.getInputStream(entry);
                OutputStream fos = Files.newOutputStream(path, new OpenOption[0]);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
            }
            jar.getInputStream(entry).close();
        }
        jar.close();
    }

    @Deprecated
    public static void compressFiles(File[] listFiles, File destZipFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destZipFile));
        for (File file : listFiles) {
            if (file.isDirectory()) {
                ZipUtils.addFolderToZip(file, file.getName(), zos);
                continue;
            }
            ZipUtils.addFileToZip(file, zos);
        }
        zos.flush();
        zos.close();
    }

    public static void compressFiles(Path[] listFiles, Path destZipFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(destZipFile, new OpenOption[0]));
        for (Path file : listFiles) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                ZipUtils.addFolderToZip(file, file.getFileName().toString(), zos);
                continue;
            }
            ZipUtils.addFileToZip(file, zos);
        }
        zos.flush();
        zos.close();
    }

    @Deprecated
    private static void addFolderToZip(File folder, String parentFolder, ZipOutputStream zos) throws IOException {
        for (File file : FileUtils.list(folder)) {
            int read;
            if (file.isDirectory()) {
                ZipUtils.addFolderToZip(file, parentFolder + "/" + file.getName(), zos);
                continue;
            }
            zos.putNextEntry(new ZipEntry(parentFolder + "/" + file.getName()));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[4096];
            while ((read = bis.read(buffer)) != -1) {
                zos.write(buffer, 0, read);
            }
            zos.closeEntry();
            bis.close();
        }
    }

    private static void addFolderToZip(Path folder, String parentFolder, ZipOutputStream zos) throws IOException {
        AtomicReference<Object> err = new AtomicReference<Object>(null);
        FileUtils.list(folder).forEach(path -> {
            try {
                int read;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    ZipUtils.addFolderToZip(path, parentFolder + '/' + path.getFileName().toString(), zos);
                    return;
                }
                zos.putNextEntry(new ZipEntry(parentFolder + "/" + path.getFileName().toString()));
                BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
                byte[] buffer = new byte[4096];
                while ((read = bis.read(buffer)) != -1) {
                    zos.write(buffer, 0, read);
                }
                zos.closeEntry();
                bis.close();
            }
            catch (IOException e) {
                err.set(e);
            }
        });
        if (err.get() != null) {
            throw new IOException(err.get());
        }
    }

    @Deprecated
    private static void addFileToZip(File file, ZipOutputStream zos) throws IOException {
        int read;
        zos.putNextEntry(new ZipEntry(file.getName()));
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        byte[] buffer = new byte[4096];
        while ((read = bis.read(buffer)) != -1) {
            zos.write(buffer, 0, read);
        }
        zos.closeEntry();
        bis.close();
    }

    private static void addFileToZip(Path file, ZipOutputStream zos) throws IOException {
        int read;
        zos.putNextEntry(new ZipEntry(file.getFileName().toString()));
        BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));
        byte[] buffer = new byte[4096];
        while ((read = bis.read(buffer)) != -1) {
            zos.write(buffer, 0, read);
        }
        zos.closeEntry();
        bis.close();
    }

    @Deprecated
    public static void unzip(String destinationDir, String zipPath) throws IOException {
        ZipUtils.unzip(new File(destinationDir), new File(zipPath));
    }

    @Deprecated
    public static void unzip(File destinationDir, String zipPath) throws IOException {
        ZipUtils.unzip(destinationDir, new File(zipPath));
    }

    @Deprecated
    public static void unzip(String destinationDir, File zipFile) throws IOException {
        ZipUtils.unzip(new File(destinationDir), zipFile);
    }

    @Deprecated
    public static void unzip(File destinationDir, File zipFile) throws IOException {
        ZipFile toUnZip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> enu = toUnZip.entries();
        while (enu.hasMoreElements()) {
            ZipEntry entry = enu.nextElement();
            File fl = new File(destinationDir + File.separator + entry.getName());
            ZipUtils.unzip0(fl, toUnZip, entry);
        }
        toUnZip.close();
    }

    public static void unzip(Path destinationDir, Path zipFile) throws IOException {
        ZipFile toUnZip = new ZipFile(zipFile.toFile());
        Enumeration<? extends ZipEntry> enu = toUnZip.entries();
        while (enu.hasMoreElements()) {
            ZipEntry entry = enu.nextElement();
            Path fl = Paths.get(destinationDir.toString(), entry.getName());
            ZipUtils.unzip0(fl, toUnZip, entry);
        }
        toUnZip.close();
    }

    @Deprecated
    private static void unzip0(File fl, ZipFile zipFile, ZipEntry entry) throws IOException {
        if (fl.getName().endsWith("/")) {
            fl.mkdirs();
        }
        if (!fl.exists()) {
            fl.getParentFile().mkdirs();
        }
        if (entry.isDirectory()) {
            return;
        }
        InputStream is = zipFile.getInputStream(entry);
        FileOutputStream fo = new FileOutputStream(fl);
        while (is.available() > 0) {
            fo.write(is.read());
        }
        fo.close();
        is.close();
    }

    private static void unzip0(Path fl, ZipFile zipFile, ZipEntry entry) throws IOException {
        if (fl.getFileName().toString().endsWith("/")) {
            Files.createDirectory(fl, new FileAttribute[0]);
        }
        if (Files.notExists(fl, new LinkOption[0])) {
            Files.createDirectories(fl.getParent(), new FileAttribute[0]);
        }
        if (entry.isDirectory()) {
            return;
        }
        BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
        BufferedOutputStream fo = new BufferedOutputStream(Files.newOutputStream(fl, new OpenOption[0]));
        while (is.available() > 0) {
            fo.write(is.read());
        }
        fo.close();
        is.close();
    }

    public static void unzipJar(String destinationDir, String jarPath, String ... args) throws IOException {
        JarFile jar = new JarFile(Paths.get(jarPath, new String[0]).toFile());
        Enumeration<JarEntry> enu = jar.entries();
        while (enu.hasMoreElements()) {
            JarEntry je = enu.nextElement();
            Path fl = Paths.get(destinationDir, je.getName());
            if (args.length >= 1 && args[0] != null && args[0].equals("ignoreMetaInf") && fl.toString().contains("META-INF")) continue;
            ZipUtils.unzip0(fl, (ZipFile)jar, (ZipEntry)je);
        }
        jar.close();
    }

    public static void unzipJars(JarPath ... jars) throws IOException {
        for (JarPath jar : jars) {
            ZipUtils.unzipJar(jar.getDestination(), jar.getJarPath(), new String[0]);
        }
    }

    public static class JarPath
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String destination;
        private final String jarPath;

        public JarPath(String destination, String jarPath) {
            this.destination = destination;
            this.jarPath = jarPath;
        }

        public String getDestination() {
            return this.destination;
        }

        public String getJarPath() {
            return this.jarPath;
        }
    }
}

