/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowio;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

public final class FileUtils {
    public static String getFileExtension(File file) {
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public static String removeExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        if (!FileUtils.getFileExtension(new File(fileName)).isEmpty()) {
            return fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName;
    }

    public static File removeExtension(File file) throws IOException {
        if (!FileUtils.getFileExtension(file).isEmpty()) {
            return Files.move(file.toPath(), new File(FileUtils.removeExtension(file.getName())).toPath(), StandardCopyOption.REPLACE_EXISTING).toFile();
        }
        return file;
    }

    @Deprecated
    public static void createFile(File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
    }

    @Deprecated
    public static void saveFile(File file, String text) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(text);
        writer.flush();
        writer.close();
    }

    @Deprecated
    public static String loadFile(File file) throws IOException {
        if (file.exists()) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder text = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                text.append(line);
            }
            reader.close();
            return text.toString();
        }
        return "";
    }

    public static void deleteDirectory(File folder) {
        if (folder.exists() && folder.isDirectory()) {
            List<File> files = FileUtils.listRecursive(folder);
            for (File f : files) {
                f.delete();
            }
            folder.delete();
        }
    }

    public static void deleteExclude(File toDelete, File ... excludes) {
        boolean flag = true;
        for (File exclude : excludes) {
            if (!exclude.getAbsolutePath().equals(toDelete.getAbsolutePath())) continue;
            flag = false;
            break;
        }
        if (flag) {
            toDelete.delete();
        }
    }

    public static List<File> listRecursive(File directory) {
        File[] fs;
        ArrayList<File> files = new ArrayList<File>();
        for (File f : fs = FileUtils.list(directory)) {
            if (f.isDirectory()) {
                files.addAll(FileUtils.listRecursive(f));
            }
            files.add(f);
        }
        return files;
    }

    public static void createDirectories(String location, String ... dirsToCreate) throws IOException {
        for (String s : dirsToCreate) {
            File f = new File(location, s);
            if (f.exists()) continue;
            Files.createDirectory(Paths.get(location + s, new String[0]), new FileAttribute[0]);
        }
    }

    public static long getFileSizeMegaBytes(File file) {
        return file.length() / 0x100000L;
    }

    public static long getFileSizeKiloBytes(File file) {
        return file.length() / 1024L;
    }

    public static long getFileSizeBytes(File file) {
        return file.length();
    }

    public static String getStringPathOfClass(Class<?> classToGetPath) {
        return classToGetPath.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public static File getFilePathOfClass(Class<?> classToGetPath) {
        return new File(classToGetPath.getProtectionDomain().getCodeSource().getLocation().getPath());
    }

    public static String getFileChecksum(MessageDigest digest, File file) throws IOException {
        int bytesCount;
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
        byte[] byteArray = new byte[1024];
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static String getMD5ofFile(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        return FileUtils.getFileChecksum(md5Digest, file);
    }

    /*
     * Exception decompiling
     */
    public static String getSHA1(File file) throws NoSuchAlgorithmException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File[] list(File dir) {
        File[] files = dir.listFiles();
        return files == null ? new File[]{} : files;
    }

    public static long getCRC32(File file) throws IOException {
        CRC32 checksum = new CRC32();
        byte[] bytes = Files.readAllBytes(file.toPath());
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }
}

