/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowzipper;

import fr.flowarg.flowio.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;

public final class ZipUtils {
    public static void decompressTarArchive(File tarGzFile, File destinationDir) {
        TarGZipUnArchiver unArchiver = new TarGZipUnArchiver();
        ConsoleLoggerManager loggerManager = new ConsoleLoggerManager();
        loggerManager.initialize();
        unArchiver.setSourceFile(tarGzFile);
        unArchiver.enableLogging(loggerManager.getLoggerForComponent("[FlowMultitools]"));
        unArchiver.setDestDirectory(destinationDir);
        destinationDir.mkdirs();
        unArchiver.extract();
    }

    public static void gzipFile(String baseFile, String newFile) throws IOException {
        byte[] buffer = new byte[1024];
        if (baseFile != null && newFile != null) {
            int bytesRead;
            FileOutputStream fileOutputStream = new FileOutputStream(newFile);
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(baseFile));
            while ((bytesRead = fileInputStream.read(buffer)) > 0) {
                gzipOutputStream.write(buffer, 0, bytesRead);
            }
            fileInputStream.close();
            gzipOutputStream.finish();
            gzipOutputStream.close();
        }
    }

    public static void unzipJarWithLZMACompat(File destinationDir, File jarFile) throws IOException {
        File file;
        String fileName;
        JarEntry entry;
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enums = jar.entries();
        while (enums.hasMoreElements()) {
            entry = enums.nextElement();
            fileName = destinationDir + File.separator + entry.getName();
            file = new File(fileName);
            if (!fileName.endsWith("/")) continue;
            file.mkdirs();
        }
        enums = jar.entries();
        while (enums.hasMoreElements()) {
            entry = enums.nextElement();
            fileName = destinationDir + File.separator + entry.getName();
            file = new File(fileName);
            if (fileName.endsWith("/")) continue;
            if (fileName.endsWith(".lzma")) {
                new File(destinationDir, "data").mkdir();
                InputStream stream = jar.getInputStream(entry);
                Files.copy(stream, new File(destinationDir, entry.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                stream.close();
            } else {
                InputStream is = jar.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(file);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
            }
            jar.getInputStream(entry).close();
        }
        jar.close();
    }

    public static void compressFiles(File[] listFiles, File destZipFile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destZipFile));
        for (File file : listFiles) {
            if (file.isDirectory()) {
                ZipUtils.addFolderToZip(file, file.getName(), zos);
                continue;
            }
            ZipUtils.addFileToZip(file, zos);
        }
        zos.flush();
        zos.close();
    }

    private static void addFolderToZip(File folder, String parentFolder, ZipOutputStream zos) throws IOException {
        for (File file : FileUtils.list(folder)) {
            int read;
            if (file.isDirectory()) {
                ZipUtils.addFolderToZip(file, parentFolder + "/" + file.getName(), zos);
                continue;
            }
            zos.putNextEntry(new ZipEntry(parentFolder + "/" + file.getName()));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[4096];
            while ((read = bis.read(buffer)) != -1) {
                zos.write(buffer, 0, read);
            }
            zos.closeEntry();
            bis.close();
        }
    }

    private static void addFileToZip(File file, ZipOutputStream zos) throws IOException {
        int read;
        zos.putNextEntry(new ZipEntry(file.getName()));
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        byte[] buffer = new byte[1024];
        while ((read = bis.read(buffer)) != -1) {
            zos.write(buffer, 0, read);
        }
        zos.closeEntry();
        bis.close();
    }

    public static void unzipJar(String destinationDir, String jarPath, String ... args) throws IOException {
        File file = new File(jarPath);
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> enu = jar.entries();
        while (enu.hasMoreElements()) {
            JarEntry je = enu.nextElement();
            File fl = new File(destinationDir + File.separator + je.getName());
            if (args.length >= 1 && args[0] != null && args[0].equals("ignoreMetaInf") && fl.getAbsolutePath().contains("META-INF")) continue;
            if (fl.getName().endsWith("/")) {
                fl.mkdirs();
            }
            if (!fl.exists()) {
                fl.getParentFile().mkdirs();
            }
            if (je.isDirectory()) continue;
            InputStream is = jar.getInputStream(je);
            FileOutputStream fo = new FileOutputStream(fl);
            while (is.available() > 0) {
                fo.write(is.read());
            }
            fo.close();
            is.close();
        }
        jar.close();
    }

    public static void unzipJars(JarPath ... jars) throws IOException {
        for (JarPath jar : jars) {
            ZipUtils.unzipJar(jar.getDestination(), jar.getJarPath(), new String[0]);
        }
    }

    public static class JarPath
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String destination;
        private final String jarPath;

        public JarPath(String destination, String jarPath) {
            this.destination = destination;
            this.jarPath = jarPath;
        }

        public String getDestination() {
            return this.destination;
        }

        public String getJarPath() {
            return this.jarPath;
        }
    }
}

