/*
 * Decompiled with CFR 0.152.
 */
package fr.coppernic.lib.splash.base;

import android.app.Activity;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import fr.coppernic.lib.splash.base.MetaConfig;
import fr.coppernic.lib.splash.base.SplashViewModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplashScreenBase
extends AppCompatActivity {
    public static final String TAG = "SplashScreen";
    private static final int REQUEST = 777;
    private static final Logger LOG = LoggerFactory.getLogger((String)"SplashScreen");
    private final Handler handler = new Handler();
    private Runnable runTargetActivity;
    private MetaConfig metaConfig;
    private Intent launcher;
    protected SplashViewModel model;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.model = (SplashViewModel)ViewModelProviders.of((FragmentActivity)this).get(SplashViewModel.class);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.metaConfig = new MetaConfig((Activity)this);
        this.launcher = this.metaConfig.getTargetIntent();
        if (this.launcher == null) {
            LOG.error("No intent to launch target activity");
            this.finish();
        } else {
            LOG.debug("Launcher intent : {}", (Object)this.launcher);
            this.runTargetActivity = new Runnable(){

                @Override
                public void run() {
                    if (SplashScreenBase.this.shouldStartActivityForResult(SplashScreenBase.this.launcher)) {
                        LOG.trace("Start activity for result : {}", (Object)SplashScreenBase.this.launcher);
                        SplashScreenBase.this.startActivityForResult(SplashScreenBase.this.launcher, 777);
                    } else {
                        SplashScreenBase.this.launcher.setFlags(0);
                        LOG.trace("Start activity : {}", (Object)SplashScreenBase.this.launcher);
                        SplashScreenBase.this.startActivity(SplashScreenBase.this.launcher);
                        SplashScreenBase.this.finish();
                    }
                }
            };
        }
    }

    protected void startTargetActivity() {
        if (this.runTargetActivity != null) {
            this.handler.postDelayed(this.runTargetActivity, (long)this.metaConfig.getTiming());
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.runTargetActivity != null) {
            this.handler.removeCallbacks(this.runTargetActivity);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        LOG.debug("onActivityResult, code : {}, result : {}, intent : {} ", new Object[]{requestCode, resultCode, data == null ? "null" : data});
        this.setResult(resultCode, data);
        this.finish();
    }

    private boolean shouldStartActivityForResult(Intent intent) {
        String action = intent.getAction();
        boolean ret = action != null && action.equals("android.intent.action.MAIN") && intent.hasCategory("android.intent.category.LAUNCHER") ? false : (intent.getFlags() & 0x10000000) == 0 || (intent.getFlags() & 0x2000000) == 0;
        return ret;
    }
}

