/*
 * Decompiled with CFR 0.152.
 */
package fr.coppernic.lib.splash;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import fr.coppernic.lib.splash.MetaConfig;
import timber.log.Timber;

public class SplashScreenBase
extends Activity {
    private static final String TAG = "SplashScreenBase";
    private static final boolean DEBUG = false;
    private static final int REQUEST = 777;
    private final Handler handler = new Handler();
    private Runnable runTargetActivity;
    private MetaConfig metaConfig;
    private Intent launcher;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.metaConfig = new MetaConfig(this);
        this.launcher = this.metaConfig.getTargetIntent();
        if (this.launcher == null) {
            Timber.e((String)"No intent to launch target activity", (Object[])new Object[0]);
            this.finish();
        } else {
            Timber.d((String)"Launcher intent : %s", (Object[])new Object[]{this.launcher});
            this.runTargetActivity = new Runnable(){

                @Override
                public void run() {
                    if (SplashScreenBase.this.shouldStartActivityForResult(SplashScreenBase.this.launcher)) {
                        SplashScreenBase.this.startActivityForResult(SplashScreenBase.this.launcher, 777);
                    } else {
                        SplashScreenBase.this.launcher.setFlags(0);
                        SplashScreenBase.this.startActivity(SplashScreenBase.this.launcher);
                        SplashScreenBase.this.finish();
                    }
                }
            };
        }
    }

    void startTargetActivity() {
        if (this.runTargetActivity != null) {
            this.handler.postDelayed(this.runTargetActivity, (long)this.metaConfig.getTiming());
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.runTargetActivity != null) {
            this.handler.removeCallbacks(this.runTargetActivity);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.setResult(resultCode, data);
        this.finish();
    }

    private boolean shouldStartActivityForResult(Intent intent) {
        boolean ret = true;
        String action = intent.getAction();
        if (action != null && action.equals("android.intent.action.MAIN") && intent.hasCategory("android.intent.category.LAUNCHER")) {
            ret = false;
        } else if ((intent.getFlags() & 0x10000000) != 0) {
            ret = false;
        }
        return ret;
    }
}

