/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import java.io.IOException;
import java.util.Date;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

public class TagDateExtractor
implements AutoCloseable {
    private final RevWalk revWalk;

    TagDateExtractor(Repository repository) {
        this.revWalk = new RevWalk(repository);
    }

    public Date dateOfTagObjectId(ObjectId tagObjectId) throws IOException {
        return this.revWalk.parseTag((AnyObjectId)tagObjectId).getTaggerIdent().getWhen();
    }

    public Date dateOfRef(Ref r) {
        try {
            return this.dateOfTagObjectId(r.getObjectId());
        }
        catch (IOException ex) {
            throw new IllegalStateException("can't parse date of tag " + r.getName(), ex);
        }
    }

    @Override
    public void close() {
        this.revWalk.close();
    }
}

