/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.cli;

import fr.brouillard.oss.jgitver.LookupPolicy;
import fr.brouillard.oss.jgitver.Strategies;
import java.io.File;
import picocli.CommandLine;

@CommandLine.Command(name="java -jar jgitver-executable.jar", version={"jgitver %s (%s)"})
public class Options {
    @CommandLine.Option(names={"-V", "--version"}, versionHelp=true, description={"display version info"})
    boolean versionInfoRequested;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display usage"})
    boolean helpRequested = false;
    @CommandLine.Option(names={"--autoIncrementPatch"}, description={"activate auto increment patch functionality"})
    boolean autoIncrementPatch = true;
    @CommandLine.Option(names={"--useDistance"}, description={"activate distance qualifier"})
    boolean useDistance = true;
    @CommandLine.Option(names={"--useDirty"}, description={"activate dirty flag"})
    boolean useDirty = true;
    @CommandLine.Option(names={"--useLongFormat"}, description={"activate long format usage"})
    boolean useLongFormat = false;
    @CommandLine.Option(names={"--useGitCommitId"}, description={"add git commit id as qualifier"})
    boolean useGitCommitId = false;
    @CommandLine.Option(names={"--gitCommitIdLength"}, description={"length of the git commit id if used"})
    Integer gitCommitIdLength;
    @CommandLine.Option(names={"--useGitCommitTimestamp"}, description={"add git commit timestamp as qualifier"})
    boolean useGitCommitTimestamp = false;
    @CommandLine.Option(names={"--strategy"}, description={"defines the strategy to use"})
    Strategies strategy = Strategies.CONFIGURABLE;
    @CommandLine.Option(names={"--pattern"}, description={"pattern to identify base tags as versionable ones"})
    String pattern;
    @CommandLine.Option(names={"--policy"}, description={"lookup policy to use to find the base tag to use"})
    LookupPolicy policy = LookupPolicy.MAX;
    @CommandLine.Option(names={"--nonQualifierBranches"}, description={"list of fixed name for non qualifier branches"})
    String nonQualifierBranches;
    @CommandLine.Option(names={"--dir", "--directory"}, description={"root directory for git project"})
    File directory = new File(System.getProperty("user.dir"));
    @CommandLine.Option(names={"--metas", "--metadatas"}, description={"metadatas to show, separated by ','"})
    String metadatas;
}

