/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver;

import fr.brouillard.oss.jgitver.BranchingPolicy;
import fr.brouillard.oss.jgitver.GitVersionCalculatorBuilder;
import fr.brouillard.oss.jgitver.LookupPolicy;
import fr.brouillard.oss.jgitver.Strategies;
import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.metadata.MetadataProvider;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;

public interface GitVersionCalculator
extends AutoCloseable,
MetadataProvider {
    public static GitVersionCalculator location(File gitRepositoryLocation) {
        ClassLoader[] classLoaders;
        if (!Objects.requireNonNull(gitRepositoryLocation).isDirectory() || !gitRepositoryLocation.canRead()) {
            throw new IllegalStateException("cannot work on non readable directory:" + gitRepositoryLocation);
        }
        for (ClassLoader classLoader : classLoaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), GitVersionCalculator.class.getClassLoader()}) {
            Iterator<GitVersionCalculatorBuilder> builders = ServiceLoader.load(GitVersionCalculatorBuilder.class, classLoader).iterator();
            if (!builders.hasNext()) continue;
            try {
                GitVersionCalculator gvc = builders.next().build(gitRepositoryLocation);
                return gvc;
            }
            catch (IOException ex) {
                throw new IllegalStateException("cannot open git repository under: " + gitRepositoryLocation, ex);
            }
        }
        try {
            Class<?> builderClass = Class.forName("fr.brouillard.oss.jgitver.impl.GitVersionCalculatorImplBuilder");
            GitVersionCalculatorBuilder builder = (GitVersionCalculatorBuilder)builderClass.newInstance();
            return builder.build(gitRepositoryLocation);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new IllegalStateException("cannot instantiate default GitVersionCalculatorImplBuilder class", ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException("using GitVersionCalculatorImplBuilder cannot open git repository under: " + gitRepositoryLocation, ex);
        }
    }

    public Version getVersionObject(boolean var1);

    public Version getVersionObject();

    public String getVersion();

    public String getVersion(boolean var1);

    @Override
    public void close() throws Exception;

    public GitVersionCalculator setAutoIncrementPatch(boolean var1);

    public GitVersionCalculator setNonQualifierBranches(String var1);

    public GitVersionCalculator setQualifierBranchingPolicies(BranchingPolicy ... var1);

    public GitVersionCalculator setQualifierBranchingPolicies(List<BranchingPolicy> var1);

    public GitVersionCalculator setUseDistance(boolean var1);

    public GitVersionCalculator setUseDirty(boolean var1);

    public GitVersionCalculator setUseLongFormat(boolean var1);

    public GitVersionCalculator setUseGitCommitId(boolean var1);

    public GitVersionCalculator setUseGitCommitTimestamp(boolean var1);

    public GitVersionCalculator setUseDefaultBranchingPolicy(boolean var1);

    public GitVersionCalculator setGitCommitIdLength(int var1);

    public GitVersionCalculator setMavenLike(boolean var1);

    public GitVersionCalculator setFindTagVersionPattern(String var1);

    @Override
    public Optional<String> meta(Metadatas var1);

    public GitVersionCalculator setStrategy(Strategies var1);

    public GitVersionCalculator setTagVersionPattern(String var1);

    public GitVersionCalculator setVersionPattern(String var1);

    public GitVersionCalculator setMaxDepth(int var1);

    public GitVersionCalculator setLookupPolicy(LookupPolicy var1);
}

