/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.speedtest.utils;

import fr.bmartel.protocol.http.HttpFrame;
import fr.bmartel.protocol.http.states.HttpStates;
import fr.bmartel.speedtest.inter.ISpeedTestListener;
import fr.bmartel.speedtest.model.SpeedTestError;
import fr.bmartel.speedtest.model.UploadStorageType;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;

public class SpeedTestUtils {
    private static SecureRandom random = new SecureRandom();

    public static String generateFileName() {
        return new BigInteger(130, random).toString(32);
    }

    public static void dispatchError(boolean forceCloseSocket, List<ISpeedTestListener> listenerList, boolean isDownload, String errorMessage) {
        if (!forceCloseSocket) {
            if (isDownload) {
                for (int i = 0; i < listenerList.size(); ++i) {
                    listenerList.get(i).onDownloadError(SpeedTestError.CONNECTION_ERROR, errorMessage);
                }
            } else {
                for (int i = 0; i < listenerList.size(); ++i) {
                    listenerList.get(i).onUploadError(SpeedTestError.CONNECTION_ERROR, errorMessage);
                }
            }
        } else {
            for (int i = 0; i < listenerList.size(); ++i) {
                listenerList.get(i).onInterruption();
            }
        }
    }

    public static byte[] readUploadData(UploadStorageType storageType, byte[] body, RandomAccessFile uploadFile, int uploadTempFileSize, int chunkSize) throws IOException {
        byte[] data;
        if (storageType == UploadStorageType.RAM_STORAGE) {
            data = Arrays.copyOfRange(body, uploadTempFileSize, uploadTempFileSize + chunkSize);
        } else {
            data = new byte[chunkSize];
            uploadFile.seek(uploadTempFileSize);
            uploadFile.read(data);
        }
        return data;
    }

    public static void dispatchSocketTimeout(boolean forceCloseSocket, List<ISpeedTestListener> listenerList, boolean isDownload, String errorMessage) {
        block4: {
            if (forceCloseSocket) break block4;
            if (isDownload) {
                for (int i = 0; i < listenerList.size(); ++i) {
                    listenerList.get(i).onDownloadError(SpeedTestError.SOCKET_TIMEOUT, errorMessage);
                }
            } else {
                for (int i = 0; i < listenerList.size(); ++i) {
                    listenerList.get(i).onUploadError(SpeedTestError.SOCKET_TIMEOUT, errorMessage);
                }
            }
        }
    }

    public static void checkHttpFrameError(boolean forceCloseSocket, List<ISpeedTestListener> listenerList, HttpStates httFrameState) {
        block4: {
            if (httFrameState == HttpStates.HTTP_FRAME_OK) break block4;
            if (!forceCloseSocket) {
                for (int i = 0; i < listenerList.size(); ++i) {
                    listenerList.get(i).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error occurred while parsing http frame");
                }
            } else {
                for (int i = 0; i < listenerList.size(); ++i) {
                    listenerList.get(i).onInterruption();
                }
            }
        }
    }

    public static void checkHttpHeaderError(boolean forceCloseSocket, List<ISpeedTestListener> listenerList, HttpStates httpHeaderState) {
        block4: {
            if (httpHeaderState == HttpStates.HTTP_FRAME_OK) break block4;
            if (!forceCloseSocket) {
                for (int i = 0; i < listenerList.size(); ++i) {
                    listenerList.get(i).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error occurred while parsing http headers");
                }
            } else {
                for (int i = 0; i < listenerList.size(); ++i) {
                    listenerList.get(i).onInterruption();
                }
            }
        }
    }

    public static void checkHttpContentLengthError(boolean forceCloseSocket, List<ISpeedTestListener> listenerList, HttpFrame httpFrame) {
        block4: {
            if (httpFrame.getContentLength() > 0) break block4;
            if (!forceCloseSocket) {
                for (int i = 0; i < listenerList.size(); ++i) {
                    listenerList.get(i).onDownloadError(SpeedTestError.INVALID_HTTP_RESPONSE, "Error content length is inconsistent");
                }
            } else {
                for (int i = 0; i < listenerList.size(); ++i) {
                    listenerList.get(i).onInterruption();
                }
            }
        }
    }
}

