/*
 * Decompiled with CFR 0.152.
 */
package fr.arthurvimond.rxbindingadapters;

import android.databinding.BindingAdapter;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import fr.arthurvimond.rxbindingadapters.Empty;
import fr.arthurvimond.rxbindingadapters.MathUtils;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import java.util.List;

public class RxBindingAdapters {
    @BindingAdapter(value={"rxClick"})
    public static void rxClick(View view, Subject<Empty> subject) {
        view.setOnClickListener(view1 -> subject.onNext((Object)Empty.VOID));
    }

    @BindingAdapter(value={"rxLongClick"})
    public static void rxLongClick(View view, Subject<Empty> subject) {
        view.setOnLongClickListener(view1 -> {
            subject.onNext((Object)Empty.VOID);
            return true;
        });
    }

    @BindingAdapter(value={"rxTouch"})
    public static void rxTouch(View view, Subject<MotionEvent> subject) {
        view.setOnTouchListener((view1, motionEvent) -> {
            subject.onNext((Object)motionEvent);
            return true;
        });
    }

    @BindingAdapter(value={"rxText"})
    public static void rxText(EditText editText, final BehaviorSubject<String> subject) {
        editText.setText((CharSequence)subject.getValue());
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
            }

            public void afterTextChanged(Editable editable) {
                subject.onNext((Object)editable.toString());
            }
        });
    }

    @BindingAdapter(value={"rxChecked"})
    public static void rxChecked(CompoundButton compoundButton, BehaviorSubject<Boolean> subject) {
        compoundButton.setChecked(((Boolean)subject.getValue()).booleanValue());
        compoundButton.setOnCheckedChangeListener((compoundButton1, checked) -> subject.onNext((Object)checked));
    }

    @BindingAdapter(value={"rxItem", "rxItems"})
    public static void rxItem(Spinner spinner, final BehaviorSubject<String> subject, List<String> items) {
        ArrayAdapter adapter = new ArrayAdapter(spinner.getContext(), 17367048, items);
        adapter.setDropDownViewResource(0x1090009);
        spinner.setAdapter((SpinnerAdapter)adapter);
        int position = adapter.getPosition(subject.getValue());
        spinner.setSelection(position);
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id) {
                String item = adapterView.getItemAtPosition(position).toString();
                if (item != null && subject.getValue() != item) {
                    subject.onNext((Object)item);
                }
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
    }

    @BindingAdapter(value={"rxItem"})
    public static void rxItem(RadioGroup radioGroup, BehaviorSubject<String> subject) {
        for (int i = 0; i < radioGroup.getChildCount(); ++i) {
            RadioButton button = (RadioButton)radioGroup.getChildAt(i);
            if (!button.getText().toString().equals(subject.getValue())) continue;
            button.setChecked(true);
        }
        radioGroup.setOnCheckedChangeListener((radioGroup1, checkedId) -> {
            RadioButton checkedButton = (RadioButton)radioGroup1.findViewById(checkedId);
            String text = checkedButton.getText().toString();
            subject.onNext((Object)text);
        });
    }

    @BindingAdapter(value={"rxProgress", "rxMin", "rxMax"})
    public static void rxProgress(SeekBar seekBar, BehaviorSubject<Integer> subject, int min, int max) {
        int step = max - min;
        RxBindingAdapters.rxProgressWithStep(seekBar, subject, min, max, step);
    }

    @BindingAdapter(value={"rxProgress", "rxMin", "rxMax", "rxStep"})
    public static void rxProgressWithStep(SeekBar seekBar, final BehaviorSubject<Integer> subject, final int min, final int max, final int step) {
        if ((Integer)subject.getValue() < min) {
            subject.onNext((Object)min);
        }
        if ((Integer)subject.getValue() > max) {
            subject.onNext((Object)max);
        }
        int mappedProgress = (int)MathUtils.map(((Integer)subject.getValue()).intValue(), min, max, 0.0f, step);
        seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    int unmappedProgress = (int)MathUtils.map(progress, 0.0f, step, min, max);
                    subject.onNext((Object)unmappedProgress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        seekBar.setMax(step);
        seekBar.setProgress(mappedProgress);
    }
}

