/*
 * Decompiled with CFR 0.152.
 */
package fr.arthurvimond.rxbindingadapters;

import android.databinding.BindingAdapter;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import fr.arthurvimond.rxbindingadapters.Empty;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.Subject;
import java.util.List;

public class RxBindingAdapters {
    @BindingAdapter(value={"rxClick"})
    public static void rxClick(View view, Subject<Empty> subject) {
        view.setOnClickListener(view1 -> subject.onNext((Object)Empty.VOID));
    }

    @BindingAdapter(value={"rxText"})
    public static void rxText(EditText editText, final BehaviorSubject<String> subject) {
        editText.setText((CharSequence)subject.getValue());
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
            }

            public void afterTextChanged(Editable editable) {
                subject.onNext((Object)editable.toString());
            }
        });
    }

    @BindingAdapter(value={"rxChecked"})
    public static void rxChecked(CompoundButton compoundButton, BehaviorSubject<Boolean> subject) {
        compoundButton.setChecked(((Boolean)subject.getValue()).booleanValue());
        compoundButton.setOnCheckedChangeListener((compoundButton1, checked) -> subject.onNext((Object)checked));
    }

    @BindingAdapter(value={"rxItem", "rxItems"})
    public static void rxItem(Spinner spinner, final BehaviorSubject<String> subject, List<String> items) {
        ArrayAdapter adapter = new ArrayAdapter(spinner.getContext(), 17367048, items);
        adapter.setDropDownViewResource(0x1090009);
        spinner.setAdapter((SpinnerAdapter)adapter);
        int position = adapter.getPosition(subject.getValue());
        spinner.setSelection(position);
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id) {
                String item = adapterView.getItemAtPosition(position).toString();
                if (item != null && subject.getValue() != item) {
                    subject.onNext((Object)item);
                }
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
    }
}

