/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.processor;

import fluent.validation.processor.Factory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"fluent.validation.processor.Factory"})
public class FactoryGenerator
extends AbstractProcessor {
    private static final Set<String> defaultPackages = new HashSet<String>(Arrays.asList("java.lang", "fluent.validation"));

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> factories = roundEnv.getElementsAnnotatedWith(Factory.class);
        if (factories.isEmpty()) {
            return false;
        }
        try (PrintWriter out = new PrintWriter(this.processingEnv.getFiler().createSourceFile("fluent.validation.Checks", new Element[0]).openWriter());){
            out.println("/*\n * BSD 2-Clause License\n *\n * Copyright (c) 2021, Ondrej Fischer\n * All rights reserved.\n *\n * Redistribution and use in source and binary forms, with or without\n * modification, are permitted provided that the following conditions are met:\n *\n *  Redistributions of source code must retain the above copyright notice, this\n *   list of conditions and the following disclaimer.\n *\n *  Redistributions in binary form must reproduce the above copyright notice,\n *   this list of conditions and the following disclaimer in the documentation\n *   and/or other materials provided with the distribution.\n *\n * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\"\n * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE\n * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL\n * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\n * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER\n * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,\n * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n *\n */\n");
            out.println("package fluent.validation;");
            out.println();
            out.println("/**\n * Factory of ready to use most frequent conditions. There are typical conditions for following categories:\n *\n * 1. General check builders for simple building of new conditions using predicate and description.\n * 2. General object conditions - e.g. isNull, notNull, equalTo, etc.\n * 3. Generalized logical operators (N-ary oneOf instead of binary or, N-ary allOf instead of binary and)\n * 4. Collection (Iterable) conditions + quantifiers\n * 5. Relational and range conditions for comparables\n * 6. String matching conditions (contains/startWith/endsWith as well as regexp matching)\n * 7. Basic XML conditions (XPath, attribute matching)\n * 8. Floating point comparison using a tolerance\n * 9. Builders for composition or collection of criteria.\n */\n");
            out.println("public final class Checks {");
            out.println();
            out.println("\tprivate Checks() {}");
            out.println();
            factories.stream().flatMap(factory -> ElementFilter.methodsIn(factory.getEnclosedElements()).stream()).filter(method -> method.getModifiers().contains((Object)Modifier.PUBLIC)).forEach(method -> {
                out.println("\t/**");
                String comment = this.processingEnv.getElementUtils().getDocComment((Element)method);
                if (Objects.nonNull(comment)) {
                    Stream.of(comment.split("\\R")).forEach(line -> out.println("\t *" + line));
                }
                out.println("\t * @see " + this.type(method.getEnclosingElement(), false) + "#" + FactoryGenerator.sig(method, (p, i) -> this.type((Element)p, false)));
                out.println("\t */");
                method.getAnnotationMirrors().forEach(a -> out.println("\t@" + this.type(a.getAnnotationType())));
                out.println("\tpublic static " + FactoryGenerator.gen(method) + this.type(method.getReturnType()) + " " + FactoryGenerator.sig(method, (p, i) -> this.type((Element)p, (boolean)i) + " " + p) + " {");
                out.println("\t\treturn " + this.type(method.getEnclosingElement(), false) + "." + FactoryGenerator.sig(method, (v, i) -> v.toString()) + ";");
                out.println("\t}");
                out.println();
            });
            out.println("}");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private String type(TypeMirror typeMirror) {
        return typeMirror.getKind() != TypeKind.DECLARED ? typeMirror.toString() : this.stripPkg(this.pkg(this.processingEnv.getTypeUtils().asElement(typeMirror)), typeMirror.toString());
    }

    private String type(Element element, boolean isVararg) {
        return isVararg ? this.type(((ArrayType)element.asType()).getComponentType()) + "..." : this.type(element.asType());
    }

    private String stripPkg(String pkg, String type) {
        return defaultPackages.contains(pkg) ? type.substring(pkg.length() + 1) : type;
    }

    private String pkg(Element element) {
        PackageElement packageOf = this.processingEnv.getElementUtils().getPackageOf(element);
        return Objects.isNull(packageOf) ? "" : packageOf.toString();
    }

    private static String gen(ExecutableElement method) {
        return method.getTypeParameters().isEmpty() ? "" : method.getTypeParameters().stream().map(p -> p.getSimpleName() + " extends " + p.getBounds().stream().map(Objects::toString).collect(Collectors.joining())).collect(Collectors.joining(", ", "<", "> "));
    }

    private static String sig(ExecutableElement method, BiFunction<VariableElement, Boolean, String> arg) {
        List<? extends VariableElement> parameters = method.getParameters();
        int size = parameters.size();
        return method.getSimpleName() + "(" + IntStream.range(0, size).mapToObj(i -> (String)arg.apply((VariableElement)parameters.get(i), method.isVarArgs() && i == size - 1)).collect(Collectors.joining(", ")) + ")";
    }
}

