/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Aggregator;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

final class SubsequenceCheck<D>
implements Check<Iterator<D>> {
    private final String elementName;
    private final List<Check<? super D>> checks;

    SubsequenceCheck(String elementName, List<Check<? super D>> checks) {
        this.elementName = elementName;
        this.checks = checks;
    }

    @Override
    public Result evaluate(Iterator<D> data, ResultFactory factory) {
        if (data == null) {
            return factory.expectation(this, false);
        }
        Aggregator resultBuilder = factory.aggregator(this);
        ArrayList<Integer> prefixes = new ArrayList<Integer>();
        while (data.hasNext()) {
            D item = data.next();
            prefixes.add(0);
            ListIterator<Integer> prefixesIterator = prefixes.listIterator();
            while (prefixesIterator.hasNext()) {
                int prefixLength = (Integer)prefixesIterator.next();
                if (resultBuilder.add(this.checks.get(prefixLength).evaluate(item, factory)).passed()) {
                    if (prefixLength + 1 == this.checks.size()) {
                        return resultBuilder.build(this.elementName + "s matched checks", true);
                    }
                    prefixesIterator.set(prefixLength + 1);
                    continue;
                }
                prefixesIterator.remove();
            }
        }
        return resultBuilder.build(this.elementName + "s matched checks", false);
    }

    public String toString() {
        return this.elementName + "s matching " + this.checks;
    }
}

