/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.Transformation;
import fluent.validation.processor.Factory;
import java.util.Objects;
import java.util.regex.Pattern;

@Factory
public final class StringChecks {
    private StringChecks() {
    }

    public static Check<String> equalCaseInsensitiveTo(String expectedValue) {
        return expectedValue == null ? BasicChecks.sameInstance(null) : BasicChecks.check(expectedValue::equalsIgnoreCase, "any case " + expectedValue);
    }

    public static Check<String> emptyString() {
        return BasicChecks.nullableCheck(data -> Objects.isNull(data) || data.isEmpty(), "is empty string");
    }

    public static Check<String> trim(Check<? super String> check) {
        return BasicChecks.compose(Transformation.dontTransformNull(String::trim), check);
    }

    public static Check<String> startsWith(String prefix) {
        return BasicChecks.check(data -> data.startsWith(prefix), "starts with <" + prefix + ">");
    }

    public static Check<String> startsCaseInsensitiveWith(String prefix) {
        return BasicChecks.check(data -> data.toLowerCase().startsWith(prefix.toLowerCase()), "starts with " + prefix);
    }

    public static Check<String> endsWith(String suffix) {
        return BasicChecks.check(data -> data.startsWith(suffix), "ends with %s" + suffix);
    }

    public static Check<String> endsCaseInsensitiveWith(String suffix) {
        return BasicChecks.check(data -> data.toLowerCase().startsWith(suffix.toLowerCase()), "ends with " + suffix);
    }

    public static Check<String> contains(String substring) {
        return BasicChecks.check(data -> data.contains(substring), "contains " + substring);
    }

    public static Check<String> containsCaseInsensitive(String substring) {
        return BasicChecks.check(data -> data.toLowerCase().contains(substring.toLowerCase()), "contains " + substring);
    }

    public static Check<String> matches(Pattern pattern) {
        return BasicChecks.check(v -> pattern.matcher((CharSequence)v).find(), "matches /" + pattern + '/');
    }

    public static Check<String> matchesPattern(String pattern) {
        return StringChecks.matches(Pattern.compile(pattern));
    }
}

