/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.result;

import fluent.validation.Check;
import fluent.validation.result.Result;
import fluent.validation.result.ResultVisitor;
import fluent.validation.result.TableInResult;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class XmlStreamResultVisitor
implements ResultVisitor {
    private final XMLStreamWriter builder;

    public XmlStreamResultVisitor(XMLStreamWriter builder) {
        this.builder = builder;
    }

    @Override
    public void actual(Object actualValue, Result result) {
        try {
            this.builder.writeStartElement("actual");
            this.builder.writeCharacters(actualValue.toString());
            this.builder.writeEndElement();
            result.accept(this);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void expectation(Object expectation, boolean result) {
        try {
            this.builder.writeStartElement("expectation");
            this.builder.writeAttribute("result", result ? "pass" : "fail");
            this.builder.writeCharacters(String.valueOf(expectation));
            this.builder.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void transformation(Object name, Result dependency, boolean result) {
        try {
            this.builder.writeStartElement("transformation");
            this.builder.writeAttribute("name", String.valueOf(name));
            this.builder.writeAttribute("result", result ? "pass" : "fail");
            dependency.accept(this);
            this.builder.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void aggregation(Object description, String glue, List<Result> itemResults, boolean result) {
        try {
            this.builder.writeStartElement("aggregation");
            this.builder.writeAttribute("name", String.valueOf(glue));
            this.builder.writeAttribute("result", result ? "pass" : "fail");
            for (Result itemResult : itemResults) {
                itemResult.accept(this);
            }
            this.builder.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void tableAggregation(Object prefix, List<Check<?>> checks, List<?> items, List<TableInResult.Cell> results, boolean value) {
    }

    @Override
    public void error(Throwable throwable) {
    }

    @Override
    public void invert(Result result) {
        result.accept(this);
    }

    @Override
    public void soft(Result result) {
        try {
            this.builder.writeStartElement("soft");
            result.accept(this);
            this.builder.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }
}

