/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.UncheckedInterruptedException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public final class Functions {
    private Functions() {
    }

    @SafeVarargs
    public static <D> Set<D> setOf(D ... values) {
        switch (values.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(values[0]);
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<D>(Arrays.asList(values)));
    }

    public static Set<String> splitToSet(String value, String splitter) {
        return Functions.setOf(value.split(splitter));
    }

    public static <D> Iterator<D> iterator(Iterable<D> iterable) {
        return iterable.iterator();
    }

    public static <D> Iterator<D> queueIterator(final Queue<D> queue) {
        return new Iterator<D>(){

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }

            @Override
            public D next() {
                return queue.poll();
            }
        };
    }

    public static <D> Iterator<D> blockingQueueIterator(final BlockingQueue<D> queue, final long timeout) {
        return new Iterator<D>(){
            private D data;
            {
                this.data = this.poll(timeout);
            }

            @Override
            public boolean hasNext() {
                return this.data != null;
            }

            @Override
            public D next() {
                Object last = this.data;
                this.data = this.poll(timeout);
                return last;
            }

            private D poll(long timeout2) {
                try {
                    return queue.poll(timeout2, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new UncheckedInterruptedException(e, (Throwable)e);
                }
            }
        };
    }
}

