/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation.evaluation;

import fluent.validation.Check;
import fluent.validation.evaluation.Conclusion;
import fluent.validation.evaluation.Context;
import fluent.validation.evaluation.Statement;
import fluent.validation.result.Result;

public class Analyzer {
    private final Context context;

    public Analyzer(Context context) {
        this.context = context;
    }

    private <T> void log(Result result, T data, Check<? super T> check, Conclusion conclusion) {
        System.out.println(result.toString());
        if (result.passed()) {
            conclusion.conclude(true, this.context);
        }
    }

    public <T> Def when(T data, Check<? super T> check) {
        return conclusion -> this.log(Check.evaluate(data, check), data, check, conclusion);
    }

    public Def when(Statement statement) {
        return conclusion -> {};
    }

    public static interface Def {
        public void then(Conclusion var1);

        default public Def and(Statement statement) {
            return this;
        }

        default public <T> Def and(T data, Check<? super T> check) {
            return this;
        }
    }
}

