/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;

final class DoubleCheck<D>
extends Check<D> {
    private final Check<? super D> requirement;
    private final Check<? super D> check;

    DoubleCheck(Check<? super D> requirement, Check<? super D> check) {
        this.requirement = requirement;
        this.check = check;
    }

    @Override
    public Result evaluate(D data, ResultFactory factory) {
        Result requirementResult = this.requirement.evaluate(data, factory);
        return requirementResult.failed() ? requirementResult : this.check.evaluate(data, factory);
    }

    @Override
    public String toString() {
        return this.check.toString();
    }
}

