/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.api.End;
import fluent.validation.And;
import fluent.validation.Or;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;

public abstract class Check<T> {
    protected abstract Result evaluate(T var1, ResultFactory var2);

    public abstract String toString();

    public <U extends T> Check<U> and(Check<? super U> operand) {
        return new And<U>(this, operand);
    }

    public <U extends T> Check<U> or(Check<? super U> operand) {
        return new Or<U>(this, operand);
    }

    @End(message="Check is not used. Pass it either to Assert.that(), Check.that() or Check.evaluate().")
    public static <T> boolean that(T data, Check<? super T> check) {
        return Check.that(data, check, ResultFactory.DEFAULT);
    }

    @End(message="Check is not used. Pass it either to Assert.that(), Check.that() or Check.evaluate().")
    public static <T> boolean that(T data, Check<? super T> check, ResultFactory resultFactory) {
        return Check.evaluate(data, check, resultFactory).passed();
    }

    public static <T> Result evaluate(T data, Check<? super T> check) {
        return Check.evaluate(data, check, ResultFactory.DEFAULT);
    }

    public static <T> Result evaluate(T data, Check<? super T> check, ResultFactory resultFactory) {
        return check.evaluate(data, resultFactory);
    }
}

