/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.AssertionFailure;
import fluent.validation.Check;
import fluent.validation.result.MismatchResultVisitor;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import fluent.validation.result.ResultVisitor;

public final class Assert {
    private Assert() {
    }

    public static <T> void that(T data, Check<? super T> check) {
        Assert.that(data, check, ResultFactory.DEFAULT);
    }

    public static <T> void that(T data, Check<? super T> check, ResultFactory resultFactory) {
        Assert.that(data, check, resultFactory, new MismatchResultVisitor());
    }

    public static <T> void that(T data, Check<? super T> check, ResultFactory resultFactory, ResultVisitor visitor) {
        Result result = resultFactory.actual(data, Check.evaluate(data, check, resultFactory));
        if (result.failed()) {
            throw new AssertionFailure(visitor.visit(result));
        }
    }
}

