/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro;

import fish.payara.micro.BootstrapException;
import fish.payara.micro.PayaraMicroRuntime;
import fish.payara.micro.boot.AdminCommandRunner;
import fish.payara.micro.boot.PayaraMicroBoot;
import fish.payara.micro.boot.PayaraMicroLauncher;
import fish.payara.micro.boot.loader.ExplodedURLClassloader;
import java.io.File;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PayaraMicro
implements PayaraMicroBoot {
    private PayaraMicroBoot wrappee;
    private ClassLoader nestedLoader;
    private static PayaraMicro instance;
    private static boolean explodedJars;
    private static File explodedDir;

    public static void unpackJars() {
        explodedJars = true;
    }

    public static void setUpackedJarDir(File file) {
        explodedDir = file;
        explodedJars = true;
    }

    public static PayaraMicro getInstance() {
        return PayaraMicro.getInstance(true);
    }

    public static PayaraMicroRuntime bootstrap() throws BootstrapException {
        return PayaraMicro.getInstance().bootStrap();
    }

    public static PayaraMicro getInstance(boolean create) {
        if (instance == null && create) {
            instance = new PayaraMicro();
        }
        return instance;
    }

    @Override
    public PayaraMicro addDeployFromGAV(String GAV) {
        this.wrappee.addDeployFromGAV(GAV);
        return this;
    }

    @Override
    public PayaraMicro addDeployment(String pathToWar) {
        this.wrappee.addDeployment(pathToWar);
        return this;
    }

    @Override
    public PayaraMicro addDeploymentFile(File file) {
        this.wrappee.addDeploymentFile(file);
        return this;
    }

    @Override
    public PayaraMicro addRepoUrl(String ... URLs) {
        this.wrappee.addRepoUrl(URLs);
        return this;
    }

    @Override
    public PayaraMicroRuntime bootStrap() throws BootstrapException {
        if (this.wrappee == null) {
            throw new BootstrapException("Could not create Runtime instance");
        }
        return this.wrappee.bootStrap();
    }

    @Override
    public File getAlternateDomainXML() {
        return this.wrappee.getAlternateDomainXML();
    }

    @Override
    public int getAutoBindRange() {
        return this.wrappee.getAutoBindRange();
    }

    @Override
    public String getClusterMulticastGroup() {
        return this.wrappee.getClusterMulticastGroup();
    }

    @Override
    public int getClusterPort() {
        return this.wrappee.getClusterPort();
    }

    @Override
    public int getClusterStartPort() {
        return this.wrappee.getClusterStartPort();
    }

    @Override
    public File getDeploymentDir() {
        return this.wrappee.getDeploymentDir();
    }

    @Override
    public boolean getHttpAutoBind() {
        return this.wrappee.getHttpAutoBind();
    }

    @Override
    public int getHttpPort() {
        return this.wrappee.getHttpPort();
    }

    @Override
    public String getHzClusterName() {
        return this.wrappee.getHzClusterName();
    }

    @Override
    public String getInstanceName() {
        return this.wrappee.getInstanceName();
    }

    @Override
    public int getMaxHttpThreads() {
        return this.wrappee.getMaxHttpThreads();
    }

    @Override
    public int getMinHttpThreads() {
        return this.wrappee.getMinHttpThreads();
    }

    @Override
    public File getRootDir() {
        return this.wrappee.getRootDir();
    }

    @Override
    public PayaraMicroRuntime getRuntime() throws IllegalStateException {
        return this.wrappee.getRuntime();
    }

    @Override
    public boolean getSslAutoBind() {
        return this.wrappee.getSslAutoBind();
    }

    @Override
    public int getSslPort() {
        return this.wrappee.getSslPort();
    }

    @Override
    public String getSslCert() {
        return this.wrappee.getSslCert();
    }

    @Override
    public File getUberJar() {
        return this.wrappee.getUberJar();
    }

    @Override
    public boolean isLite() {
        return this.wrappee.isLite();
    }

    @Override
    public boolean isNoCluster() {
        return this.wrappee.isNoCluster();
    }

    @Override
    public PayaraMicro setAccessLogDir(String filePath) {
        this.wrappee.setAccessLogDir(filePath);
        return this;
    }

    @Override
    public PayaraMicro setAccessLogFormat(String format) {
        this.wrappee.setAccessLogFormat(format);
        return this;
    }

    @Override
    public PayaraMicro setAlternateDomainXML(File alternateDomainXML) {
        this.wrappee.setAlternateDomainXML(alternateDomainXML);
        return this;
    }

    @Override
    public PayaraMicro setApplicationDomainXML(String domainXml) {
        this.wrappee.setApplicationDomainXML(domainXml);
        return this;
    }

    @Override
    public PayaraMicroBoot setPreBootHandler(Consumer<AdminCommandRunner> handler) {
        this.wrappee.setPreBootHandler(handler);
        return this;
    }

    @Override
    public PayaraMicroBoot setPostBootHandler(Consumer<AdminCommandRunner> handler) {
        this.wrappee.setPostBootHandler(handler);
        return this;
    }

    @Override
    public PayaraMicro setAutoBindRange(int autoBindRange) {
        this.wrappee.setAutoBindRange(autoBindRange);
        return this;
    }

    @Override
    public PayaraMicro setClusterMulticastGroup(String hzMulticastGroup) {
        this.wrappee.setClusterMulticastGroup(hzMulticastGroup);
        return this;
    }

    @Override
    public PayaraMicro setClusterPort(int hzPort) {
        this.wrappee.setClusterPort(hzPort);
        return this;
    }

    @Override
    public PayaraMicro setClusterStartPort(int hzStartPort) {
        this.wrappee.setClusterStartPort(hzStartPort);
        return this;
    }

    @Override
    public PayaraMicro setDeploymentDir(File deploymentRoot) {
        this.wrappee.setDeploymentDir(deploymentRoot);
        return this;
    }

    @Override
    public PayaraMicro setHttpAutoBind(boolean httpAutoBind) {
        this.wrappee.setHttpAutoBind(httpAutoBind);
        return this;
    }

    @Override
    public PayaraMicro setHttpPort(int httpPort) {
        this.wrappee.setHttpPort(httpPort);
        return this;
    }

    @Override
    public PayaraMicro setHzClusterName(String hzClusterName) {
        this.wrappee.setHzClusterName(hzClusterName);
        return this;
    }

    @Override
    public String getInstanceGroup() {
        return this.wrappee.getInstanceGroup();
    }

    @Override
    public PayaraMicro setInstanceGroup(String instanceGroup) {
        this.wrappee.setInstanceGroup(instanceGroup);
        return this;
    }

    @Override
    public PayaraMicro setInstanceName(String instanceName) {
        this.wrappee.setInstanceName(instanceName);
        return this;
    }

    @Override
    public PayaraMicro setLite(boolean liteMember) {
        this.wrappee.setLite(liteMember);
        return this;
    }

    @Override
    public PayaraMicro setLogPropertiesFile(File fileName) {
        this.wrappee.setLogPropertiesFile(fileName);
        return this;
    }

    @Override
    public PayaraMicro setLogoFile(String filePath) {
        this.wrappee.setLogoFile(filePath);
        return this;
    }

    @Override
    public PayaraMicro setMaxHttpThreads(int maxHttpThreads) {
        this.wrappee.setMaxHttpThreads(maxHttpThreads);
        return this;
    }

    @Override
    public PayaraMicro setMinHttpThreads(int minHttpThreads) {
        this.wrappee.setMinHttpThreads(minHttpThreads);
        return this;
    }

    @Override
    public PayaraMicro setNoCluster(boolean noCluster) {
        this.wrappee.setNoCluster(noCluster);
        return this;
    }

    @Override
    public PayaraMicro setPrintLogo(boolean generate) {
        this.wrappee.setPrintLogo(generate);
        return this;
    }

    @Override
    public PayaraMicro setRootDir(File rootDir) {
        this.wrappee.setRootDir(rootDir);
        return this;
    }

    @Override
    public PayaraMicro setSslAutoBind(boolean sslAutoBind) {
        this.wrappee.setSslAutoBind(sslAutoBind);
        return this;
    }

    @Override
    public PayaraMicro setSslPort(int sslPort) {
        this.wrappee.setSslPort(sslPort);
        return this;
    }

    @Override
    public PayaraMicro setSslCert(String alias) {
        this.wrappee.setSslCert(alias);
        return this;
    }

    @Override
    public PayaraMicro setUserLogFile(String fileName) {
        this.wrappee.setUserLogFile(fileName);
        return this;
    }

    @Override
    public PayaraMicro setSniEnabled(boolean value) {
        this.wrappee.setSniEnabled(value);
        return this;
    }

    @Override
    public void shutdown() throws BootstrapException {
        this.wrappee.shutdown();
    }

    public ClassLoader setThreadBootstrapLoader() {
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.nestedLoader);
        return result;
    }

    public static void main(String ... args) {
        try {
            PayaraMicroLauncher.main(args);
        }
        catch (Exception ex) {
            Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private PayaraMicro() {
        try {
            if (explodedJars) {
                this.nestedLoader = explodedDir != null ? new ExplodedURLClassloader(explodedDir) : new ExplodedURLClassloader();
                this.setThreadBootstrapLoader();
                Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass("fish.payara.micro.impl.PayaraMicroImpl");
                Method instanceMethod = mainClass.getDeclaredMethod("getInstance", new Class[0]);
                this.wrappee = (PayaraMicroBoot)instanceMethod.invoke(null, new Object[0]);
            } else {
                this.wrappee = PayaraMicroLauncher.getBootClass();
                this.nestedLoader = this.wrappee.getClass().getClassLoader();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, "Unable to create implementation class", ex);
        }
    }

    @Override
    public PayaraMicro addLibrary(File lib) {
        this.wrappee.addLibrary(lib);
        return this;
    }
}

