/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.boot.loader;

import fish.payara.micro.boot.loader.OpenURLClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExplodedURLClassloader
extends OpenURLClassLoader {
    private final File explodedDir;
    private boolean deleteOnExit = false;
    private static final String JAR_DOMAIN_DIR = "MICRO-INF/runtime/";
    private static final String LIB_DOMAIN_DIR = "MICRO-INF/lib/";

    public ExplodedURLClassloader(File explodeTo) throws IOException {
        super(new URL[0]);
        this.explodedDir = explodeTo;
        System.setProperty("fish.payara.micro.tmpdir", this.explodedDir.getAbsolutePath());
        this.explodeJars();
    }

    public ExplodedURLClassloader() throws IOException {
        super(new URL[0]);
        File directory = File.createTempFile("payaramicro-rt", "tmp");
        System.setProperty("fish.payara.micro.tmpdir", directory.getAbsolutePath());
        if (!directory.delete() || !directory.mkdir()) {
            throw new IOException("Unable to create temporary runtime directory");
        }
        this.deleteOnExit = true;
        directory.deleteOnExit();
        this.explodedDir = directory;
        this.explodeJars();
    }

    private void explodeJars() throws IOException {
        File runtimeDir = new File(this.explodedDir, "runtime");
        runtimeDir.mkdirs();
        if (this.deleteOnExit) {
            runtimeDir.deleteOnExit();
        }
        File libDir = new File(this.explodedDir, "lib");
        libDir.mkdirs();
        if (this.deleteOnExit) {
            libDir.deleteOnExit();
        }
        System.setProperty("fish.payara.micro.UnpackDir", this.explodedDir.getAbsolutePath());
        CodeSource src = ExplodedURLClassloader.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            try {
                String[] jars = src.getLocation().toURI().getSchemeSpecificPart().split("!");
                File file = new File(jars[0]);
                try (JarFile jar = new JarFile(file);){
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String fileName = null;
                        if (entry.getName().startsWith(JAR_DOMAIN_DIR)) {
                            fileName = entry.getName().substring(JAR_DOMAIN_DIR.length());
                        } else if (entry.getName().startsWith(LIB_DOMAIN_DIR)) {
                            fileName = entry.getName().substring(LIB_DOMAIN_DIR.length());
                        }
                        if (fileName == null) continue;
                        File outputFile = new File(runtimeDir, fileName);
                        if (this.deleteOnExit) {
                            outputFile.deleteOnExit();
                        }
                        super.addURL(outputFile.getAbsoluteFile().toURI().toURL());
                        if (entry.isDirectory()) {
                            outputFile.mkdirs();
                            continue;
                        }
                        InputStream is = jar.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            Files.copy(is, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                }
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(ExplodedURLClassloader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

