/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.boot;

import fish.payara.micro.boot.PayaraMicroBoot;
import fish.payara.micro.boot.loader.ExecutableArchiveLauncher;
import fish.payara.micro.boot.loader.archive.Archive;
import fish.payara.micro.boot.loader.jar.JarFile;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;

public class PayaraMicroLauncher
extends ExecutableArchiveLauncher {
    private static final String JAR_MODULES_DIR = "MICRO-INF/runtime";
    private static final String JAR_CLASSES_DIR = "MICRO-INF/classes";
    private static final String JAR_LIB_DIR = "MICRO-INF/lib";
    private static final String MICRO_JAR_PROPERTY = "fish.payara.micro.BootJar";
    private static PayaraMicroBoot bootInstance;
    private static boolean mainBoot;

    public static void main(String[] args) throws Exception {
        PayaraMicroLauncher.create("main", args);
    }

    public static PayaraMicroBoot create(String[] args) throws Exception {
        return PayaraMicroLauncher.create("create", args);
    }

    private static PayaraMicroBoot create(String method, String[] args) throws Exception {
        PayaraMicroLauncher launcher = new PayaraMicroLauncher();
        ProtectionDomain protectionDomain = PayaraMicroLauncher.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource == null ? null : codeSource.getLocation().toURI();
        System.setProperty(MICRO_JAR_PROPERTY, location.toString());
        mainBoot = true;
        return (PayaraMicroBoot)launcher.launch(method, args);
    }

    public static PayaraMicroBoot getBootClass() throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        if (bootInstance == null) {
            if (mainBoot) {
                Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass("fish.payara.micro.impl.PayaraMicroImpl");
                Method instanceMethod = mainClass.getDeclaredMethod("getInstance", new Class[0]);
                bootInstance = (PayaraMicroBoot)instanceMethod.invoke(null, new Object[0]);
            } else {
                PayaraMicroLauncher launcher = new PayaraMicroLauncher();
                ProtectionDomain protectionDomain = PayaraMicroLauncher.class.getProtectionDomain();
                CodeSource codeSource = protectionDomain.getCodeSource();
                URI location = codeSource == null ? null : codeSource.getLocation().toURI();
                System.setProperty(MICRO_JAR_PROPERTY, location.toString());
                ClassLoader loader = launcher.createClassLoader(launcher.getClassPathArchives());
                JarFile.registerUrlProtocolHandler();
                Thread.currentThread().setContextClassLoader(loader);
                Class<?> mainClass = Thread.currentThread().getContextClassLoader().loadClass("fish.payara.micro.impl.PayaraMicroImpl");
                Method instanceMethod = mainClass.getDeclaredMethod("getInstance", new Class[0]);
                bootInstance = (PayaraMicroBoot)instanceMethod.invoke(null, new Object[0]);
            }
        }
        return bootInstance;
    }

    @Override
    protected boolean isNestedArchive(Archive.Entry entry) {
        boolean result = false;
        if (entry.isDirectory() && entry.getName().equals(JAR_CLASSES_DIR)) {
            result = true;
        } else if ((entry.getName().startsWith(JAR_LIB_DIR) || entry.getName().startsWith(JAR_MODULES_DIR)) && !entry.getName().endsWith(".gitkeep")) {
            result = true;
        }
        return result;
    }

    @Override
    protected void postProcessClassPathArchives(List<Archive> archives) throws Exception {
        archives.add(0, this.getArchive());
    }

    static {
        mainBoot = false;
    }
}

