/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.WeldCollections;

public class BeanMethods {
    @SuppressWarnings(value={"rawtypes"})
    private static final Predicate<EnhancedAnnotatedMethod> BRIDGE_METHOD_FILTER_PREDICATE = new Predicate<EnhancedAnnotatedMethod>(){

        @Override
        @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
        public boolean apply(EnhancedAnnotatedMethod method) {
            Preconditions.checkArgumentNotNull(method, "method");
            return !((Method)method.getJavaMember()).isBridge();
        }
    };

    private BeanMethods() {
    }

    private static <T, R> R getMethods(EnhancedAnnotatedType<T> type2, MethodListBuilder<T, R> builder) {
        Collection<EnhancedAnnotatedMethod<?, T>> methods = BeanMethods.filterOutBridgeMethods(builder.getAllMethods(type2));
        for (Class clazz = type2.getJavaClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            builder.levelStart(clazz);
            for (EnhancedAnnotatedMethod<?, T> method : methods) {
                if (!((Method)method.getJavaMember()).getDeclaringClass().equals(clazz)) continue;
                builder.processMethod(method);
            }
            builder.levelFinish();
        }
        return builder.create();
    }

    public static <T> List<AnnotatedMethod<? super T>> getPostConstructMethods(final EnhancedAnnotatedType<T> type2) {
        return (List)BeanMethods.getMethods(type2, new AbstractLifecycleEventCallbackMethodListBuilder<T>(){

            @Override
            public Collection<EnhancedAnnotatedMethod<?, ? super T>> getAllMethods(EnhancedAnnotatedType<T> type22) {
                return type22.getEnhancedMethods(PostConstruct.class);
            }

            @Override
            protected void duplicateMethod(EnhancedAnnotatedMethod<?, ? super T> method) {
                throw UtilLogger.LOG.tooManyPostConstructMethods(type2);
            }

            @Override
            protected EnhancedAnnotatedMethod<?, ? super T> processLevelResult(EnhancedAnnotatedMethod<?, ? super T> method) {
                BeanLogger.LOG.foundOnePostConstructMethod(method, type2);
                return method;
            }
        });
    }

    public static <T> List<AnnotatedMethod<? super T>> getPreDestroyMethods(final EnhancedAnnotatedType<T> type2) {
        return (List)BeanMethods.getMethods(type2, new AbstractLifecycleEventCallbackMethodListBuilder<T>(){

            @Override
            public Collection<EnhancedAnnotatedMethod<?, ? super T>> getAllMethods(EnhancedAnnotatedType<T> type22) {
                return type22.getEnhancedMethods(PreDestroy.class);
            }

            @Override
            protected void duplicateMethod(EnhancedAnnotatedMethod<?, ? super T> method) {
                throw UtilLogger.LOG.tooManyPreDestroyMethods(type2);
            }

            @Override
            protected EnhancedAnnotatedMethod<?, ? super T> processLevelResult(EnhancedAnnotatedMethod<?, ? super T> method) {
                BeanLogger.LOG.foundOnePreDestroyMethod(method, type2);
                return method;
            }
        });
    }

    public static <T> List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethods(Bean<?> declaringBean, EnhancedAnnotatedType<T> type2, BeanManagerImpl manager) {
        return (List)BeanMethods.getMethods(type2, new InitializerMethodListBuilder<T>(type2, declaringBean, manager));
    }

    public static <T> Collection<EnhancedAnnotatedMethod<?, ? super T>> getObserverMethods(EnhancedAnnotatedType<T> type2) {
        return BeanMethods.filterOutBridgeMethods(type2.getEnhancedMethodsWithAnnotatedParameters(Observes.class));
    }

    public static <T> Collection<EnhancedAnnotatedMethod<?, ? super T>> filterOutBridgeMethods(Collection<EnhancedAnnotatedMethod<?, ? super T>> methods) {
        return Collections2.filter(methods, BRIDGE_METHOD_FILTER_PREDICATE);
    }

    public static <T> List<Method> getInterceptorMethods(EnhancedAnnotatedType<T> type2, final InterceptionType interceptionType, final boolean targetClass) {
        return (List)BeanMethods.getMethods(type2, new MethodListBuilder<T, List<Method>>(){
            List<Method> methodMetadata = null;

            @Override
            public Collection<EnhancedAnnotatedMethod<?, ? super T>> getAllMethods(EnhancedAnnotatedType<T> type2) {
                return type2.getEnhancedMethods(InterceptionTypeRegistry.getAnnotationClass(interceptionType));
            }

            @Override
            public void levelStart(Class<? super T> clazz) {
            }

            @Override
            public void processMethod(EnhancedAnnotatedMethod<?, ? super T> method) {
                Member javaMethod = method.getJavaMember();
                if (InterceptorMetadataUtils.isInterceptorMethod(interceptionType, (Method)javaMethod, targetClass)) {
                    if (this.methodMetadata == null) {
                        this.methodMetadata = new LinkedList<Method>();
                    }
                    if (System.getSecurityManager() == null) {
                        ((Method)javaMethod).setAccessible(true);
                    } else {
                        AccessController.doPrivileged(SetAccessibleAction.of(javaMethod));
                    }
                    this.methodMetadata.add((Method)method.getJavaMember());
                }
            }

            @Override
            public void levelFinish() {
            }

            @Override
            public List<Method> create() {
                if (this.methodMetadata == null) {
                    return Collections.emptyList();
                }
                Collections.reverse(this.methodMetadata);
                return ImmutableList.copyOf(this.methodMetadata);
            }
        });
    }

    private static class InitializerMethodListBuilder<T>
    implements MethodListBuilder<T, List<Set<MethodInjectionPoint<?, ?>>>> {
        private final List<Set<MethodInjectionPoint<?, ?>>> result = new ArrayList();
        private ImmutableSet.Builder<MethodInjectionPoint<?, ?>> currentLevel = null;
        private final EnhancedAnnotatedType<T> type;
        private final BeanManagerImpl manager;
        private final Bean<?> declaringBean;

        public InitializerMethodListBuilder(EnhancedAnnotatedType<T> type2, Bean<?> declaringBean, BeanManagerImpl manager) {
            this.type = type2;
            this.manager = manager;
            this.declaringBean = declaringBean;
        }

        @Override
        public Collection<EnhancedAnnotatedMethod<?, ? super T>> getAllMethods(EnhancedAnnotatedType<T> type2) {
            return type2.getEnhancedMethods(Inject.class);
        }

        @Override
        public void levelStart(Class<? super T> clazz) {
            this.currentLevel = ImmutableSet.builder();
        }

        @Override
        public void processMethod(EnhancedAnnotatedMethod<?, ? super T> method) {
            if (method.isAnnotationPresent(Inject.class)) {
                if (method.getAnnotation(Produces.class) != null) {
                    throw UtilLogger.LOG.initializerCannotBeProducer(method, this.type);
                }
                if (method.getEnhancedParameters(Disposes.class).size() > 0) {
                    throw UtilLogger.LOG.initializerCannotBeDisposalMethod(method, this.type);
                }
                if (method.getEnhancedParameters(Observes.class).size() > 0) {
                    throw EventLogger.LOG.invalidInitializer(method);
                }
                if (method.isGeneric()) {
                    throw UtilLogger.LOG.initializerMethodIsGeneric(method, this.type);
                }
                if (!method.isStatic()) {
                    this.currentLevel.add((Object)InjectionPointFactory.instance().createMethodInjectionPoint(method, this.declaringBean, this.type.getJavaClass(), null, this.manager));
                }
            }
        }

        @Override
        public void levelFinish() {
            this.result.add((Set<MethodInjectionPoint<?, ?>>)((Object)this.currentLevel.build()));
        }

        @Override
        public List<Set<MethodInjectionPoint<?, ?>>> create() {
            Collections.reverse(this.result);
            return WeldCollections.immutableGuavaList(this.result);
        }
    }

    private static abstract class AbstractLifecycleEventCallbackMethodListBuilder<T>
    implements MethodListBuilder<T, List<AnnotatedMethod<? super T>>> {
        protected List<AnnotatedMethod<? super T>> result = new ArrayList<AnnotatedMethod<? super T>>();
        protected EnhancedAnnotatedMethod<?, ? super T> foundMethod = null;

        private AbstractLifecycleEventCallbackMethodListBuilder() {
        }

        @Override
        public void levelStart(Class<? super T> clazz) {
            this.foundMethod = null;
        }

        @Override
        public void processMethod(EnhancedAnnotatedMethod<?, ? super T> method) {
            if (this.methodHasNoParameters(method)) {
                if (this.foundMethod != null) {
                    this.duplicateMethod(method);
                }
                this.foundMethod = method;
            }
        }

        private boolean methodHasNoParameters(EnhancedAnnotatedMethod<?, ? super T> method) {
            return method.getParameterTypesAsArray().length == 0;
        }

        @Override
        public void levelFinish() {
            if (this.foundMethod != null) {
                this.result.add(this.processLevelResult(this.foundMethod).slim());
            }
        }

        @Override
        public List<AnnotatedMethod<? super T>> create() {
            Collections.reverse(this.result);
            return WeldCollections.immutableList(this.result);
        }

        protected abstract void duplicateMethod(EnhancedAnnotatedMethod<?, ? super T> var1);

        protected abstract EnhancedAnnotatedMethod<?, ? super T> processLevelResult(EnhancedAnnotatedMethod<?, ? super T> var1);
    }

    private static interface MethodListBuilder<T, R> {
        public Collection<EnhancedAnnotatedMethod<?, ? super T>> getAllMethods(EnhancedAnnotatedType<T> var1);

        public void levelStart(Class<? super T> var1);

        public void processMethod(EnhancedAnnotatedMethod<?, ? super T> var1);

        public void levelFinish();

        public R create();
    }
}

